package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayProfitAmtItemRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS010-普通提现请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayWithdrawRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 结算金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 以元单位，小数部分四舍五入保留2位小数
     */
    @NotNull(message = "结算金额不能为空")
    private BigDecimal amount;

    /**
     * 手续费金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 以元单位，小数部分四舍五入保留2位小数，不计入交易金额
     */
    private BigDecimal feeamt;

    /**
     * 分账信息
     * 必填: 否
     * 长度: 1000
     * 说明: Json格式，每一个元素包含商户号merid和分账金额profitamt。如： "{"profitamtList":[{"merid":"CM3000047819","profitamt":"0.1","prno":"1000000001"},{"merid":"CF3000038788","profitamt":"0.1","prno":"1000000002"}]}"
     * 对应对象: MsfpayProfitAmtItemRequest
     * prno为项目编号,非必输
     */
    private MsfpayProfitAmtItemRequest profitamtlist;

    /**
     * 交易金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 分账时必输。交易金额=结算金额+分账总金额，以元单位，小数部分四舍五入保留2位小数
     */
    private BigDecimal tranamt;

    /**
     * 交易备注
     * 必填: 否
     * 长度: 30
     */
    private String remark;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
