package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayRefundItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS006-退款请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayRefundRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 原支付订单号
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "原支付订单号不能为空")
    private String oritranflow;

    /**
     * 退款金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 以元单位，小数部分四舍五入保留2位小数
     */
    @NotNull(message = "退款金额不能为空")
    private BigDecimal refundamt;

    /**
     * 退款明细
     * 必填: 是
     * 长度: 255
     * 说明: {"refundlist":[{"merid":"CF3000038556","refundamt":"0.01","prno":"1000000001"},{"merid":"CF3000038508","refundamt":"0.01","prno": "1000000001"}]}
     * 对应对象: MsfpayRefundItemListRequest
     */
    private MsfpayRefundItemListRequest refundlist;

    /**
     * 退款备注
     * 必填: 是
     * 长度: 60
     */
    @NotBlank(message = "退款备注不能为空")
    private String remark;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 是否支持现金账户(账户余额)退款
     * 必填: 否
     * 长度: 2
     * 说明: Y：支持 N：不支持，默认为N
     */
    private String issupportcash;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
