package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayFeeSubsidyRuleItemRequest;
import com.fshows.msfpay.request.item.MsfpayProductItemListRequest;
import com.fshows.msfpay.request.item.MsfpayProfitItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * CAS002-快捷支付请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayQuickPayRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 外部用户号
     * 必填: 否
     * 长度: 32
     */
    private String outuserid;

    /**
     * 账号
     * 必填: 是
     * 长度: 32
     * 说明: 银行卡号或者存折号码
     */
    @NotBlank(message = "账号不能为空")
    private String accountno;

    /**
     * 账户名称
     * 必填: 是
     * 长度: 60
     * 说明: 银行卡或者存折上对应的名称
     */
    @NotBlank(message = "账户名称不能为空")
    private String accountname;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 以元单位， 银行卡被扣费的金额,保留小数2位。整数位最大为14位。
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 开户证件类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：身份证；目前仅支持身份证
     */
    @NotBlank(message = "开户证件类型不能为空")
    private String certtype;

    /**
     * 证件号
     * 必填: 是
     * 长度: 22
     * 说明: 身份证号码
     */
    @NotBlank(message = "证件号不能为空")
    private String certno;

    /**
     * 手机号码
     * 必填: 是
     * 长度: 13
     * 说明: 银行预留手机号
     */
    @NotBlank(message = "手机号码不能为空")
    private String mobileno;

    /**
     * 订单号
     * 必填: 是
     * 长度: 30
     * 说明: 鉴权返回流水号
     */
    @NotBlank(message = "订单号不能为空")
    private String merorderid;

    /**
     * 客户号
     * 必填: 是
     * 长度: 30
     * 说明: 商户需要记录以在第二步快捷支付中使用
     */
    @NotBlank(message = "客户号不能为空")
    private String custid;

    /**
     * 令牌信息
     * 必填: 是
     * 长度: 50
     * 说明: 需要记录以在第二步快捷支付中使用
     */
    @NotBlank(message = "令牌信息不能为空")
    private String phonetoken;

    /**
     * 手机验证码
     * 必填: 是
     * 长度: 6
     * 说明: 持卡人收到的手机验证码
     */
    @NotBlank(message = "手机验证码不能为空")
    private String phonevercode;

    /**
     * 服务器回调地址
     * 必填: 否
     * 长度: 128
     * 说明: 订单成功之后作为服务器回调的地址
     */
    private String serverurl;

    /**
     * 订单类型
     * 必填: 是
     * 长度: 2
     * 说明: 订单类型：0:普通交易1:担保交易
     */
    @NotBlank(message = "订单类型不能为空")
    private String ordertype;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 说明: 平台商户开通之后三方平台会告知订单收费规则按照三方指定的收费规则计算上送。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "平台手续费不能为空")
    private BigDecimal patfee;

    /**
     * 分账类型
     * 必填: 是
     * 长度: 2
     * 说明: 见附件，当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotBlank(message = "分账类型不能为空")
    private String profittype;

    /**
     * 分账信息
     * 必填: 是
     * 长度: 3000
     * JSON格式的分账信息
     * 对应对象: MsfpayProfitItemRequest
     */
    @NotNull(message = "分账信息不能为空")
    private MsfpayProfitItemListRequest profitlist;

    /**
     * 商品信息
     * 必填: 是
     * 长度: 255
     * JSON格式的商品信息
     * 对应对象: MsfpayProductItemListRequest
     */
    @NotNull(message = "商品信息不能为空")
    private MsfpayProductItemListRequest productlist;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 优惠标识
     * 必填: 否
     * 长度: 32
     * 说明: 与CAS003接口上送相同
     */
    private String coupontoken;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 手续费补贴费率明细
     * 必填: 否
     * 说明: [{"activityCode":"MKT1000000000","payType":"QUICKPAY","subsidyRatio":0.1},{"activityCode":"MKT1000000001","payType":"QUICKPAY","subsidyRatio":0.2}]
     * 对应对象: MsfpayFeeSubsidyRuleItemRequest
     */
    private List<MsfpayFeeSubsidyRuleItemRequest> feeSubsidyRuleList;
}
