package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS025-商户信息变更确认请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMerchantInfoChangeConfirmRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 金额
     * 必填: 否
     * 长度: 10
     * 说明: 需要回填打款金额时必输
     */
    private String tranamt;

    /**
     * 验证码
     * 必填: 否
     * 长度: 6
     * 说明: 需要回填验证码时必输
     */
    private String phonevercode;

    /**
     * 验证令牌
     * 必填: 是
     * 长度: 50
     */
    @NotBlank(message = "验证令牌不能为空")
    private String phonetoken;
}
