package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * CAS051-会员分账(商户在途资金)请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMemberSplitTransitRequest extends MsfpayBizRequest {

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户号不能为空")
    private String merid;

    /**
     * 会员编号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "会员编号不能为空")
    private String memUserId;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 14,2
     */
    @NotBlank(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 备注
     * 必填: 否
     * 长度: 64
     */
    private String remark;

    /**
     * 用途
     * 必填: 否
     * 长度: 64
     */
    private String usage;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 银行卡号
     * 必填: 否
     * 长度: 32
     * 说明: 不填默认分账到默认卡
     */
    private String bankcardno;
}
