package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS049-申请注册会员请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMemberRegisterRequest extends MsfpayBizRequest {

    /**
     * 签约手机号
     * 必填: 是
     * 长度: 11
     */
    @NotBlank(message = "签约手机号不能为空")
    private String phone;

    /**
     * 会员名称
     * 必填: 是
     * 长度: 64
     */
    @NotBlank(message = "会员名称不能为空")
    private String custname;

    /**
     * 会员类型
     * 必填: 是
     * 长度: 1
     * 说明: 1个体户 2企业 3个人
     */
    @NotBlank(message = "会员类型不能为空")
    private String usertype;

    /**
     * 证件类型
     * 必填: 否
     * 长度: 3
     * 说明: 101 营业执照 105 登记证书
     */
    private String custcerttype;

    /**
     * 证件号码
     * 必填: 否
     * 长度: 22
     */
    private String custcertno;

    /**
     * 证件照片
     * 必填: 否
     * 长度: 128
     */
    private String busphotourl;

    /**
     * 经营地址省编码
     * 必填: 否
     * 长度: 6
     */
    private String busprocode;

    /**
     * 经营地址市编码
     * 必填: 否
     * 长度: 6
     */
    private String buscitycode;

    /**
     * 经营地址区县编码
     * 必填: 否
     * 长度: 6
     */
    private String busregioncode;

    /**
     * 经营地址详细地址
     * 必填: 否
     * 长度: 128
     */
    private String busadd;

    /**
     * 姓名
     * 必填: 否
     * 长度: 64
     * 说明: 法人姓名或经营者姓名
     */
    private String name;

    /**
     * 身份证正面照片
     * 必填: 否
     * 长度: 64
     */
    private String idfrontimgurl;

    /**
     * 身份证反面照片
     * 必填: 否
     * 长度: 64
     */
    private String idbackimgurl;

    /**
     * 证件类型
     * 必填: 否
     * 长度: 64
     * 说明: 0 身份证 2 护照 5港澳居民来往内地通行证 6台湾同胞来往内地通行证
     */
    private String certtype;

    /**
     * 证件号码
     * 必填: 否
     * 长度: 22
     */
    private String certno;

    /**
     * 证件有效期开始
     * 必填: 否
     * 长度: 8
     * 说明: yyyyMMdd
     */
    private String signdate;

    /**
     * 证件有效期截止
     * 必填: 否
     * 长度: 64
     * 说明: yyyyMMdd
     */
    private String certdate;

    /**
     * 证件地址省编码
     * 必填: 否
     * 长度: 6
     */
    private String procode;

    /**
     * 证件地址市编码
     * 必填: 否
     * 长度: 64
     */
    private String citycode;

    /**
     * 证件地址区县编码
     * 必填: 否
     * 长度: 64
     */
    private String regioncode;

    /**
     * 证件地址详细地址
     * 必填: 否
     * 长度: 64
     */
    private String address;

    /**
     * 是否默认卡
     * 必填: 否
     * 长度: 1
     * 说明: Y、N
     */
    private String defcard;

    /**
     * 银行卡类型
     * 必填: 否
     * 长度: 2
     * 说明: 01 借记 99 企业账户
     */
    private String bankcardtype;

    /**
     * 银行卡号
     * 必填: 否
     * 长度: 32
     */
    private String bankcardno;

    /**
     * 银行卡户名
     * 必填: 否
     * 长度: 64
     */
    private String bankcardname;

    /**
     * 预留手机号
     * 必填: 否
     * 长度: 11
     */
    private String bankprephone;

    /**
     * 银行编码
     * 必填: 否
     * 长度: 12
     */
    private String bankcode;

    /**
     * 开户省编码
     * 必填: 否
     * 长度: 6
     */
    private String openprocode;

    /**
     * 开户市编码
     * 必填: 否
     * 长度: 6
     */
    private String opencitycode;

    /**
     * 银行卡照片或开户证明文件
     * 必填: 否
     * 长度: 128
     */
    private String bankcardimgurl;

    /**
     * 回调url
     * 必填: 否
     * 长度: 128
     * 说明: 如果传递了该参数，页面签约提交后点击返回会访问该地址
     */
    private String serverurl;

    /**
     * 开户声明文件
     * 必填: 否
     * 长度: 128
     */
    private String declareimgurl;

    /**
     * 开户意愿视频
     * 必填: 否
     * 长度: 128
     */
    private String wishvdourl;

    /**
     * 职业
     * 必填: 否
     * 长度: 32
     */
    private String occupation;

    /**
     * 常驻地址省编码
     * 必填: 否
     * 长度: 6
     */
    private String residentPCode;

    /**
     * 常驻地址市编码
     * 必填: 否
     * 长度: 6
     */
    private String residentCCode;

    /**
     * 常驻地址区县编码
     * 必填: 否
     * 长度: 6
     */
    private String residentDCode;

    /**
     * 常驻地址详细地址
     * 必填: 否
     * 长度: 128
     */
    private String residentaddress;
}
