package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS003-上传商户影像信息请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayImageUploadRequest extends MsfpayBizRequest {

    /**
     * 照片或压缩文件内容
     * 必填: 是
     * 长度: 1048576
     * 说明: Base64编码格式的字符流，字节数 [1-1048576]；图片格式：png,gif,jpg,bmp；压缩文件格式：zip
     */
    @NotBlank(message = "照片或压缩文件内容不能为空")
    private String imgs;
}
