package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS040-修改二级商户手续费补贴费率请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayFeeSubsidyModifyRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 费率编号
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "费率编号不能为空")
    private String id;

    /**
     * 有效期开始日期
     * 必填: 否
     * 长度: 10
     * 说明: 格式：yyyy-MM-dd
     */
    private String startDate;

    /**
     * 有效期截止日期
     * 必填: 否
     * 长度: 10
     * 说明: 格式：yyyy-MM-dd
     */
    private String endDate;

    /**
     * 状态
     * 必填: 否
     * 长度: 20
     * 说明: DISABLE:不可用
     */
    private String state;
}
