package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayProfitAmtListRequest;
import com.fshows.msfpay.response.item.MsfpayProfitAmtListResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS025-额度提现请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayCreditWithdrawRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 交易金额=实际付款金额+分账总金额一致，以元单位，小数部分四舍五入保留2位小数
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 实际付款金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 实际结算到银行卡金额，以元单位，小数部分四舍五入保留2位小数
     */
    @NotNull(message = "实际付款金额不能为空")
    private BigDecimal amount;

    /**
     * 手续费金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 不计入交易金额，以元单位，小数部分四舍五入保留2位小数
     */
    @NotNull(message = "手续费金额不能为空")
    private BigDecimal feeamt;

    /**
     * 分账信息
     * 必填: 否
     * 说明: 每一个元素包含商户号merid和分账金额profitamt。如： "{"profitamtList":[{"merid":"CM3000047819","profitamt":"0.1","prno":"1000000001"},{"merid":"CF3000038788","profitamt":"0.1","prno":"1000000002"}]}",prno为项目编号,非必输
     * 对应对象: MsfpayProfitAmtListRequest
     */
    private MsfpayProfitAmtListRequest profitamtlist;

    /**
     * 交易备注
     * 必填: 否
     * 长度: 30
     */
    private String remark;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
