package com.fshows.msfpay.request;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.msfpay.constant.MsfpayConstant;
import lombok.Data;
import java.math.BigDecimal;

/**
 * 中投科信支付基础请求类
 * 注意：公共参数（platmerid、tranflow、trancode、mertrandate、mertrantime、ztpage）
 * 由SDK自动填充，业务方只需关注业务参数即可
 */
@Data
public class MsfpayBizRequest implements IRequestDefinition {

    /**
     * 商户号
     * 服务商id/平台商户号,一般以CF开头
     * SDK自动填充，无需设置
     */
    private String platmerid;

    /**
     * 交易流水（交易订单号）
     * （全局唯一）服务商id +（日期+序列号），此流水号为全局流水号
     * SDK自动生成，也可手动设置
     */
    private String tranflow;

    /**
     * 交易编码
     * 以CMS、CAS开头的6位编码，如CMS044或者CAS016
     * SDK自动填充，无需设置
     */
    private String trancode;

    /**
     * 客户端交易日期
     * YYYYMMDD
     * SDK自动填充，无需设置
     */
    private String mertrandate;

    /**
     * 客户端交易时间
     * HHmmss
     * SDK自动填充，无需设置
     */
    private String mertrantime;

    /**
     * 客户端交易时间
     * yyyyMMddHHmmss
     * SDK自动填充，无需设置
     */
    private String trantime;

    /**
     * 是否页面
     * true:跳转页面 false：不跳页面，不输入默认为false
     * SDK自动填充，无需设置
     */
    private String ztpage;
}
