package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS018-条码支付状态变更请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayBarcodeStatusRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 通道编码
     * 必填: 是
     * 长度: 8
     * 说明: 条码支付开通时返回，取值范围：Qr004、Qr003
     */
    @NotBlank(message = "通道编码不能为空")
    private String chlcode;

    /**
     * 通道类型
     * 必填: 是
     * 长度: 32
     * 说明: WEIXIN 微信、ALI 支付宝、UP 银联、UPAPP 银联APP、HUABEI花呗分期
     */
    @NotBlank(message = "通道类型不能为空")
    private String chltype;

    /**
     * 经营类目
     * 必填: 否
     * 长度: 10
     * 说明: 支付宝必填
     */
    private String industryid;

    /**
     * appid
     * 必填: 否
     * 长度: 32
     * 说明: 支付宝pid，微信appid，支付宝必填
     */
    private String appid;

    /**
     * 客服电话
     * 必填: 否
     * 长度: 18
     * 说明: 支付宝必填，微信商户简称和客服电话至少填一个
     */
    private String servtel;

    /**
     * 证件号码
     * 必填: 否
     * 长度: 32
     */
    private String businessLicense;

    /**
     * 证件类型
     * 必填: 否
     * 长度: 32
     * 说明: NATIONAL_LEGAL营业执照、NATIONAL_LEGAL_MERGE 营业执照(多证合一)、INST_RGST_CTF事业单位法人证书
     */
    private String businessLicenseType;

    /**
     * 商户状态（渠道侧）
     * 必填: 否
     * 长度: 2
     * 说明: 商户状态，取值范围：00：启用；（缺省值）01：注销；注销状态的商户，将无法完成支付类交易。
     */
    private String merchantState;
}
