package com.fshows.msfpay.apienum;

import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.msfpay.request.MsfpayBarcodePayRequest;
import com.fshows.msfpay.request.MsfpayOnlineBankPayRequest;
import com.fshows.msfpay.request.MsfpayQuickPayRequest;
import com.fshows.msfpay.request.MsfpayQuickAuthRequest;
import com.fshows.msfpay.request.MsfpayGuaranteeConfirmRequest;
import com.fshows.msfpay.request.MsfpayTransferPayRequest;
import com.fshows.msfpay.request.MsfpayPlatformTransferRequest;
import com.fshows.msfpay.request.MsfpayFeeTransferRequest;
import com.fshows.msfpay.request.MsfpayTransactionCancelRequest;
import com.fshows.msfpay.request.MsfpayAgreementSignRequest;
import com.fshows.msfpay.request.MsfpayAgreementConfirmRequest;
import com.fshows.msfpay.request.MsfpayAgreementPayRequest;
import com.fshows.msfpay.request.MsfpayAgreementUnsignRequest;
import com.fshows.msfpay.request.MsfpayInstallmentPayRequest;
import com.fshows.msfpay.request.MsfpayCouponQueryRequest;
import com.fshows.msfpay.request.MsfpayCouponCancelRequest;
import com.fshows.msfpay.request.MsfpayCashierPayRequest;
import com.fshows.msfpay.request.MsfpayQuickCashierOrderRequest;
import com.fshows.msfpay.request.MsfpayRefundRequest;
import com.fshows.msfpay.request.MsfpayWithdrawRequest;
import com.fshows.msfpay.request.MsfpayTransactionQueryRequest;
import com.fshows.msfpay.request.MsfpayCreditWithdrawRequest;
import com.fshows.msfpay.request.MsfpayAccountBalanceQueryRequest;
import com.fshows.msfpay.request.MsfpayMerchantInfoQueryRequest;
import com.fshows.msfpay.request.MsfpayWechatAuthCodeRequest;
import com.fshows.msfpay.request.MsfpayWechatFacePayAuthRequest;
import com.fshows.msfpay.request.MsfpayAgreementStatusQueryRequest;
import com.fshows.msfpay.request.MsfpayMemberSplitRequest;
import com.fshows.msfpay.request.MsfpayMemberSplitQueryRequest;
import com.fshows.msfpay.request.MsfpayMemberSplitWhitelistRequest;
import com.fshows.msfpay.request.MsfpayMemberSplitTransitRequest;
import com.fshows.msfpay.request.MsfpayWhitelistQueryRequest;
import com.fshows.msfpay.request.MsfpaySettlementDetailQueryRequest;
import com.fshows.msfpay.request.MsfpayInstallmentPeriodsQueryRequest;
import com.fshows.msfpay.request.MsfpayUnionPayAuthCodeRequest;
import com.fshows.msfpay.request.MsfpayWithdrawDetailQueryRequest;
import com.fshows.msfpay.response.MsfpayBarcodePayResponse;
import com.fshows.msfpay.response.MsfpayOnlineBankPayResponse;
import com.fshows.msfpay.response.MsfpayQuickPayResponse;
import com.fshows.msfpay.response.MsfpayQuickAuthResponse;
import com.fshows.msfpay.response.MsfpayGuaranteeConfirmResponse;
import com.fshows.msfpay.response.MsfpayTransferPayResponse;
import com.fshows.msfpay.response.MsfpayPlatformTransferResponse;
import com.fshows.msfpay.response.MsfpayFeeTransferResponse;
import com.fshows.msfpay.response.MsfpayTransactionCancelResponse;
import com.fshows.msfpay.response.MsfpayAgreementSignResponse;
import com.fshows.msfpay.response.MsfpayAgreementConfirmResponse;
import com.fshows.msfpay.response.MsfpayAgreementPayResponse;
import com.fshows.msfpay.response.MsfpayAgreementUnsignResponse;
import com.fshows.msfpay.response.MsfpayInstallmentPayResponse;
import com.fshows.msfpay.response.MsfpayCouponQueryResponse;
import com.fshows.msfpay.response.MsfpayCouponCancelResponse;
import com.fshows.msfpay.response.MsfpayCashierPayResponse;
import com.fshows.msfpay.response.MsfpayQuickCashierOrderResponse;
import com.fshows.msfpay.response.MsfpayRefundResponse;
import com.fshows.msfpay.response.MsfpayWithdrawResponse;
import com.fshows.msfpay.response.MsfpayTransactionQueryResponse;
import com.fshows.msfpay.response.MsfpayCreditWithdrawResponse;
import com.fshows.msfpay.response.MsfpayAccountBalanceQueryResponse;
import com.fshows.msfpay.response.MsfpayMerchantInfoQueryResponse;
import com.fshows.msfpay.response.MsfpayWechatAuthCodeResponse;
import com.fshows.msfpay.response.MsfpayWechatFacePayAuthResponse;
import com.fshows.msfpay.response.MsfpayAgreementStatusQueryResponse;
import com.fshows.msfpay.response.MsfpayMemberSplitResponse;
import com.fshows.msfpay.response.MsfpayMemberSplitQueryResponse;
import com.fshows.msfpay.response.MsfpayMemberSplitWhitelistResponse;
import com.fshows.msfpay.response.MsfpayMemberSplitTransitResponse;
import com.fshows.msfpay.response.MsfpayWhitelistQueryResponse;
import com.fshows.msfpay.response.MsfpaySettlementDetailQueryResponse;
import com.fshows.msfpay.response.MsfpayInstallmentPeriodsQueryResponse;
import com.fshows.msfpay.response.MsfpayUnionPayAuthCodeResponse;
import com.fshows.msfpay.response.MsfpayWithdrawDetailQueryResponse;
import lombok.Getter;

/**
 * 中投科信支付API定义枚举 - 支付类接口 (CAS)
 */
@Getter
public enum MsfpayPayApiDefinitionEnum implements IApiDefinition {

    /**
     * CAS001-网银支付
     */
    CAS001_ONLINE_BANK_PAY(
        "网银支付",
        "CAS001",
        "1.0.0",
        "CAS",
        MsfpayOnlineBankPayRequest.class,
        MsfpayOnlineBankPayResponse.class
    ),

    /**
     * CAS002-快捷支付
     */
    CAS002_QUICK_PAY(
        "快捷支付",
        "CAS002",
        "1.0.0",
        "CAS",
        MsfpayQuickPayRequest.class,
        MsfpayQuickPayResponse.class
    ),

    /**
     * CAS003-快捷鉴权
     */
    CAS003_QUICK_AUTH(
        "快捷鉴权",
        "CAS003",
        "1.0.0",
        "CAS",
        MsfpayQuickAuthRequest.class,
        MsfpayQuickAuthResponse.class
    ),

    /**
     * CAS006-退款
     */
    CAS006_REFUND(
        "退款",
        "CAS006",
        "1.0.0",
        "CAS",
        MsfpayRefundRequest.class,
        MsfpayRefundResponse.class
    ),

    /**
     * CAS008-交易状态查询
     */
    CAS008_TRANSACTION_QUERY(
        "交易状态查询",
        "CAS008",
        "1.0.0",
        "CAS",
        MsfpayTransactionQueryRequest.class,
        MsfpayTransactionQueryResponse.class
    ),

    /**
     * CAS010-普通提现
     */
    CAS010_WITHDRAW(
        "普通提现",
        "CAS010",
        "1.0.0",
        "CAS",
        MsfpayWithdrawRequest.class,
        MsfpayWithdrawResponse.class
    ),

    /**
     * CAS011-账户余额查询
     */
    CAS011_ACCOUNT_BALANCE_QUERY(
        "账户余额查询",
        "CAS011",
        "1.0.0",
        "CAS",
        MsfpayAccountBalanceQueryRequest.class,
        MsfpayAccountBalanceQueryResponse.class
    ),

    /**
     * CAS015-担保交易确认
     */
    CAS015_GUARANTEE_CONFIRM(
        "担保交易确认",
        "CAS015",
        "1.0.0",
        "CAS",
        MsfpayGuaranteeConfirmRequest.class,
        MsfpayGuaranteeConfirmResponse.class
    ),

    /**
     * CAS016-条码支付
     */
    CAS016_BARCODE_PAY(
        "条码支付",
        "CAS016",
        "1.0.0",
        "CAS",
        MsfpayBarcodePayRequest.class,
        MsfpayBarcodePayResponse.class
    ),

    /**
     * CAS017-平台转账
     */
    CAS017_PLATFORM_TRANSFER(
        "平台转账",
        "CAS017",
        "1.0.0",
        "CAS",
        MsfpayPlatformTransferRequest.class,
        MsfpayPlatformTransferResponse.class
    ),

    /**
     * CAS020-手续费转账
     */
    CAS020_FEE_TRANSFER(
        "手续费转账",
        "CAS020",
        "1.0.0",
        "CAS",
        MsfpayFeeTransferRequest.class,
        MsfpayFeeTransferResponse.class
    ),

    /**
     * CAS025-额度提现
     */
    CAS025_CREDIT_WITHDRAW(
        "额度提现",
        "CAS025",
        "1.0.0",
        "CAS",
        MsfpayCreditWithdrawRequest.class,
        MsfpayCreditWithdrawResponse.class
    ),

    /**
     * CAS026-商户信息查询
     */
    CAS026_MERCHANT_INFO_QUERY(
        "商户信息查询",
        "CAS026",
        "1.0.0",
        "CAS",
        MsfpayMerchantInfoQueryRequest.class,
        MsfpayMerchantInfoQueryResponse.class
    ),

    /**
     * CAS027-交易撤销
     */
    CAS027_TRANSACTION_CANCEL(
        "交易撤销",
        "CAS027",
        "1.0.0",
        "CAS",
        MsfpayTransactionCancelRequest.class,
        MsfpayTransactionCancelResponse.class
    ),

    /**
     * CAS028-协议签约
     */
    CAS028_AGREEMENT_SIGN(
        "协议签约",
        "CAS028",
        "1.0.0",
        "CAS",
        MsfpayAgreementSignRequest.class,
        MsfpayAgreementSignResponse.class
    ),

    /**
     * CAS029-协议签约确认
     */
    CAS029_AGREEMENT_CONFIRM(
        "协议签约确认",
        "CAS029",
        "1.0.0",
        "CAS",
        MsfpayAgreementConfirmRequest.class,
        MsfpayAgreementConfirmResponse.class
    ),

    /**
     * CAS030-协议支付
     */
    CAS030_AGREEMENT_PAY(
        "协议支付",
        "CAS030",
        "1.0.0",
        "CAS",
        MsfpayAgreementPayRequest.class,
        MsfpayAgreementPayResponse.class
    ),

    /**
     * CAS031-协议解约
     */
    CAS031_AGREEMENT_UNSIGN(
        "协议解约",
        "CAS031",
        "1.0.0",
        "CAS",
        MsfpayAgreementUnsignRequest.class,
        MsfpayAgreementUnsignResponse.class
    ),

    /**
     * CAS032-协议支付签约状态查询
     */
    CAS032_AGREEMENT_STATUS_QUERY(
        "协议支付签约状态查询",
        "CAS032",
        "1.0.0",
        "CAS",
        MsfpayAgreementStatusQueryRequest.class,
        MsfpayAgreementStatusQueryResponse.class
    ),

    /**
     * CAS033-微信授权码获取openid
     */
    CAS033_WECHAT_AUTH_CODE(
        "微信授权码获取openid",
        "CAS033",
        "1.0.0",
        "CAS",
        MsfpayWechatAuthCodeRequest.class,
        MsfpayWechatAuthCodeResponse.class
    ),

    /**
     * CAS034-微信刷脸支付调用凭证
     */
    CAS034_WECHAT_FACE_PAY_AUTH(
        "微信刷脸支付调用凭证",
        "CAS034",
        "1.0.0",
        "CAS",
        MsfpayWechatFacePayAuthRequest.class,
        MsfpayWechatFacePayAuthResponse.class
    ),

    /**
     * CAS038-分期支付
     */
    CAS038_INSTALLMENT_PAY(
        "分期支付",
        "CAS038",
        "1.0.0",
        "CAS",
        MsfpayInstallmentPayRequest.class,
        MsfpayInstallmentPayResponse.class
    ),

    /**
     * CAS044-优惠券查询
     */
    CAS044_COUPON_QUERY(
        "优惠券查询",
        "CAS044",
        "1.0.0",
        "CAS",
        MsfpayCouponQueryRequest.class,
        MsfpayCouponQueryResponse.class
    ),

    /**
     * CAS045-优惠券取消
     */
    CAS045_COUPON_CANCEL(
        "优惠券取消",
        "CAS045",
        "1.0.0",
        "CAS",
        MsfpayCouponCancelRequest.class,
        MsfpayCouponCancelResponse.class
    ),

    /**
     * CAS046-转账支付
     */
    CAS046_TRANSFER_PAY(
        "转账支付",
        "CAS046",
        "1.0.0",
        "CAS",
        MsfpayTransferPayRequest.class,
        MsfpayTransferPayResponse.class
    ),

    /**
     * CAS048-会员分账
     */
    CAS048_MEMBER_SPLIT(
        "会员分账",
        "CAS048",
        "1.0.0",
        "CAS",
        MsfpayMemberSplitRequest.class,
        MsfpayMemberSplitResponse.class
    ),

    /**
     * CAS049-会员分账交易状态查询
     */
    CAS049_MEMBER_SPLIT_QUERY(
        "会员分账交易状态查询",
        "CAS049",
        "1.0.0",
        "CAS",
        MsfpayMemberSplitQueryRequest.class,
        MsfpayMemberSplitQueryResponse.class
    ),

    /**
     * CAS050-添加会员分账白名单
     */
    CAS050_MEMBER_SPLIT_WHITELIST(
        "添加会员分账白名单",
        "CAS050",
        "1.0.0",
        "CAS",
        MsfpayMemberSplitWhitelistRequest.class,
        MsfpayMemberSplitWhitelistResponse.class
    ),

    /**
     * CAS051-会员分账(商户在途资金)
     */
    CAS051_MEMBER_SPLIT_TRANSIT(
        "会员分账(商户在途资金)",
        "CAS051",
        "1.0.0",
        "CAS",
        MsfpayMemberSplitTransitRequest.class,
        MsfpayMemberSplitTransitResponse.class
    ),

    /**
     * CAS052-白名单信息查询
     */
    CAS052_WHITELIST_QUERY(
        "白名单信息查询",
        "CAS052",
        "1.0.0",
        "CAS",
        MsfpayWhitelistQueryRequest.class,
        MsfpayWhitelistQueryResponse.class
    ),

    /**
     * CAS054-查询结算明细数据
     */
    CAS054_SETTLEMENT_DETAIL_QUERY(
        "查询结算明细数据",
        "CAS054",
        "1.0.0",
        "CAS",
        MsfpaySettlementDetailQueryRequest.class,
        MsfpaySettlementDetailQueryResponse.class
    ),

    /**
     * CAS057-查询分期期数
     */
    CAS057_INSTALLMENT_PERIODS_QUERY(
        "查询分期期数",
        "CAS057",
        "1.0.0",
        "CAS",
        MsfpayInstallmentPeriodsQueryRequest.class,
        MsfpayInstallmentPeriodsQueryResponse.class
    ),

    /**
     * CAS059-银联授权码获取用户userid
     */
    CAS059_UNIONPAY_AUTH_CODE(
        "银联授权码获取用户userid",
        "CAS059",
        "1.0.0",
        "CAS",
        MsfpayUnionPayAuthCodeRequest.class,
        MsfpayUnionPayAuthCodeResponse.class
    ),

    /**
     * CAS062-查询提现明细数据
     */
    CAS062_WITHDRAW_DETAIL_QUERY(
        "查询提现明细数据",
        "CAS062",
        "1.0.0",
        "CAS",
        MsfpayWithdrawDetailQueryRequest.class,
        MsfpayWithdrawDetailQueryResponse.class
    ),

    /**
     * CAS062-收银台支付
     */
    CAS062_CASHIER_PAY(
        "收银台支付",
        "CAS062",
        "1.0.0",
        "CAS",
        MsfpayCashierPayRequest.class,
        MsfpayCashierPayResponse.class
    ),

    /**
     * CAS063-快捷收银台下单
     */
    CAS063_QUICK_CASHIER_ORDER(
        "快捷收银台下单",
        "CAS063",
        "1.0.0",
        "CAS",
        MsfpayQuickCashierOrderRequest.class,
        MsfpayQuickCashierOrderResponse.class
    ),
    ;
    
    /**
     * 接口名称
     */
    private final String name;
    
    /**
     * 交易编码
     */
    private final String trancode;
    
    /**
     * 接口版本
     */
    private final String version;
    
    /**
     * 接口类型
     */
    private final String interfaceType;
    
    /**
     * 请求业务参数的Class类型
     */
    private final Class requestClass;
    
    /**
     * 响应业务参数的Class类型
     */
    private final Class responseClass;
    
    MsfpayPayApiDefinitionEnum(String name,
            String trancode,
            String version,
            String interfaceType,
            Class requestClass,
            Class responseClass) {
        this.name = name;
        this.trancode = trancode;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }
    
    @Override
    public String getApiURI() {
        return trancode;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
