package com.fshows.msfpay.apienum;

import com.fshows.msfpay.request.MsfpayBarcodeOpenRequest;
import com.fshows.msfpay.request.MsfpayBarcodeStatusRequest;
import com.fshows.msfpay.request.MsfpayCreditBusinessApplyRequest;
import com.fshows.msfpay.request.MsfpayCustomSplitApplyRequest;
import com.fshows.msfpay.request.MsfpayFeeSubsidyConfigRequest;
import com.fshows.msfpay.request.MsfpayFeeSubsidyCouponCreateRequest;
import com.fshows.msfpay.request.MsfpayFeeSubsidyModifyRequest;
import com.fshows.msfpay.request.MsfpayFeeSubsidyQueryRequest;
import com.fshows.msfpay.request.MsfpayImageDeleteRequest;
import com.fshows.msfpay.request.MsfpayImageUploadRequest;
import com.fshows.msfpay.request.MsfpayMemberInfoQueryRequest;
import com.fshows.msfpay.request.MsfpayMemberRegisterRequest;
import com.fshows.msfpay.request.MsfpayMerchantConfirmRequest;
import com.fshows.msfpay.request.MsfpayMerchantInfoChangeConfirmRequest;
import com.fshows.msfpay.request.MsfpayMerchantInfoChangeRequest;
import com.fshows.msfpay.request.MsfpayMerchantInfoModifyRequest;
import com.fshows.msfpay.request.MsfpayMerchantRegisterRequest;
import com.fshows.msfpay.request.MsfpayMerchantSignRequest;
import com.fshows.msfpay.request.MsfpayPlatformConfigQueryRequest;
import com.fshows.msfpay.request.MsfpayProjectAccountManageRequest;
import com.fshows.msfpay.request.MsfpayProjectManageRequest;
import com.fshows.msfpay.request.MsfpaySettleCardBindRequest;
import com.fshows.msfpay.request.MsfpaySettleCardConfirmRequest;
import com.fshows.msfpay.request.MsfpaySettlementConfigModifyRequest;
import com.fshows.msfpay.request.MsfpaySettlementConfigQueryRequest;
import com.fshows.msfpay.request.MsfpayTerminalInfoReportRequest;
import com.fshows.msfpay.request.MsfpayWechatConfigRequest;
import com.fshows.msfpay.response.MsfpayBarcodeOpenResponse;
import com.fshows.msfpay.response.MsfpayBarcodeStatusResponse;
import com.fshows.msfpay.response.MsfpayCreditBusinessApplyResponse;
import com.fshows.msfpay.response.MsfpayCustomSplitApplyResponse;
import com.fshows.msfpay.response.MsfpayFeeSubsidyConfigResponse;
import com.fshows.msfpay.response.MsfpayFeeSubsidyCouponCreateResponse;
import com.fshows.msfpay.response.MsfpayFeeSubsidyModifyResponse;
import com.fshows.msfpay.response.MsfpayFeeSubsidyQueryResponse;
import com.fshows.msfpay.response.MsfpayImageDeleteResponse;
import com.fshows.msfpay.response.MsfpayImageUploadResponse;
import com.fshows.msfpay.response.MsfpayMemberInfoQueryResponse;
import com.fshows.msfpay.response.MsfpayMemberRegisterResponse;
import com.fshows.msfpay.response.MsfpayMerchantConfirmResponse;
import com.fshows.msfpay.response.MsfpayMerchantInfoChangeConfirmResponse;
import com.fshows.msfpay.response.MsfpayMerchantInfoChangeResponse;
import com.fshows.msfpay.response.MsfpayMerchantInfoModifyResponse;
import com.fshows.msfpay.response.MsfpayMerchantRegisterResponse;
import com.fshows.msfpay.response.MsfpayMerchantSignResponse;
import com.fshows.msfpay.response.MsfpayPlatformConfigQueryResponse;
import com.fshows.msfpay.response.MsfpayProjectAccountManageResponse;
import com.fshows.msfpay.response.MsfpayProjectManageResponse;
import com.fshows.msfpay.response.MsfpaySettleCardBindResponse;
import com.fshows.msfpay.response.MsfpaySettleCardConfirmResponse;
import com.fshows.msfpay.response.MsfpaySettlementConfigModifyResponse;
import com.fshows.msfpay.response.MsfpaySettlementConfigQueryResponse;
import com.fshows.msfpay.response.MsfpayTerminalInfoReportResponse;
import com.fshows.msfpay.response.MsfpayWechatConfigResponse;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import lombok.Getter;

/**
 * 中投科信支付API定义枚举 - 商户管理类接口 (CMS)
 */
@Getter
public enum MsfpayMerchantApiDefinitionEnum implements IApiDefinition {

    /**
     * CMS003-上传商户影像信息
     */
    CMS003_IMAGE_UPLOAD(
        "上传商户影像信息",
        "CMS003",
        "1.0.0",
        "CMS",
        MsfpayImageUploadRequest.class,
        MsfpayImageUploadResponse.class
    ),

    /**
     * CMS011-条码支付开通
     */
    CMS011_BARCODE_OPEN(
        "条码支付开通",
        "CMS011",
        "1.0.0",
        "CMS",
        MsfpayBarcodeOpenRequest.class,
        MsfpayBarcodeOpenResponse.class
    ),

    /**
     * CMS012-结算卡绑定
     */
    CMS012_SETTLE_CARD_BIND(
        "结算卡绑定",
        "CMS012",
        "1.0.0",
        "CMS",
        MsfpaySettleCardBindRequest.class,
        MsfpaySettleCardBindResponse.class
    ),

    /**
     * CMS013-二级商户进件
     */
    CMS013_MERCHANT_REGISTER(
        "二级商户进件",
        "CMS013",
        "1.0.0",
        "CMS",
        MsfpayMerchantRegisterRequest.class,
        MsfpayMerchantRegisterResponse.class
    ),

    /**
     * CMS014-二级商户签约
     */
    CMS014_MERCHANT_SIGN(
        "二级商户签约",
        "CMS014",
        "1.0.0",
        "CMS",
        MsfpayMerchantSignRequest.class,
        MsfpayMerchantSignResponse.class
    ),

    /**
     * CMS015-微信配置
     */
    CMS015_WECHAT_CONFIG(
        "微信配置",
        "CMS015",
        "1.0.0",
        "CMS",
        MsfpayWechatConfigRequest.class,
        MsfpayWechatConfigResponse.class
    ),

    /**
     * CMS016-结算卡绑定确认
     */
    CMS016_SETTLE_CARD_CONFIRM(
        "结算卡绑定确认",
        "CMS016",
        "1.0.0",
        "CMS",
        MsfpaySettleCardConfirmRequest.class,
        MsfpaySettleCardConfirmResponse.class
    ),

    /**
     * CMS018-条码支付状态变更
     */
    CMS018_BARCODE_STATUS(
        "条码支付状态变更",
        "CMS018",
        "1.0.0",
        "CMS",
        MsfpayBarcodeStatusRequest.class,
        MsfpayBarcodeStatusResponse.class
    ),

    /**
     * CMS021-额度业务申请
     */
    CMS021_CREDIT_BUSINESS_APPLY(
        "额度业务申请",
        "CMS021",
        "1.0.0",
        "CMS",
        MsfpayCreditBusinessApplyRequest.class,
        MsfpayCreditBusinessApplyResponse.class
    ),

    /**
     * CMS023-商户信息修改
     */
    CMS023_MERCHANT_INFO_MODIFY(
        "商户信息修改",
        "CMS023",
        "1.0.0",
        "CMS",
        MsfpayMerchantInfoModifyRequest.class,
        MsfpayMerchantInfoModifyResponse.class
    ),

    /**
     * CMS024-商户信息变更
     */
    CMS024_MERCHANT_INFO_CHANGE(
        "商户信息变更",
        "CMS024",
        "1.0.0",
        "CMS",
        MsfpayMerchantInfoChangeRequest.class,
        MsfpayMerchantInfoChangeResponse.class
    ),

    /**
     * CMS025-商户信息变更确认
     */
    CMS025_MERCHANT_INFO_CHANGE_CONFIRM(
        "商户信息变更确认",
        "CMS025",
        "1.0.0",
        "CMS",
        MsfpayMerchantInfoChangeConfirmRequest.class,
        MsfpayMerchantInfoChangeConfirmResponse.class
    ),

    /**
     * CMS032-影像删除
     */
    CMS032_IMAGE_DELETE(
        "影像删除",
        "CMS032",
        "1.0.0",
        "CMS",
        MsfpayImageDeleteRequest.class,
        MsfpayImageDeleteResponse.class
    ),

    /**
     * CMS033-手续费补贴配置
     */
    CMS033_FEE_SUBSIDY_CONFIG(
        "手续费补贴配置",
        "CMS033",
        "1.0.0",
        "CMS",
        MsfpayFeeSubsidyConfigRequest.class,
        MsfpayFeeSubsidyConfigResponse.class
    ),

    /**
     * CMS034-手续费补贴查询
     */
    CMS034_FEE_SUBSIDY_QUERY(
        "手续费补贴查询",
        "CMS034",
        "1.0.0",
        "CMS",
        MsfpayFeeSubsidyQueryRequest.class,
        MsfpayFeeSubsidyQueryResponse.class
    ),

    /**
     * CMS036-商户终端信息报备
     */
    CMS036_TERMINAL_INFO_REPORT(
        "商户终端信息报备",
        "CMS036",
        "1.0.0",
        "CMS",
        MsfpayTerminalInfoReportRequest.class,
        MsfpayTerminalInfoReportResponse.class
    ),

    /**
     * CMS040-修改二级商户手续费补贴费率
     */
    CMS040_FEE_SUBSIDY_MODIFY(
        "修改二级商户手续费补贴费率",
        "CMS040",
        "1.0.0",
        "CMS",
        MsfpayFeeSubsidyModifyRequest.class,
        MsfpayFeeSubsidyModifyResponse.class
    ),

    /**
     * CMS041-二级商户项目管理
     */
    CMS041_PROJECT_MANAGE(
        "二级商户项目管理",
        "CMS041",
        "1.0.0",
        "CMS",
        MsfpayProjectManageRequest.class,
        MsfpayProjectManageResponse.class
    ),

    /**
     * CMS042-二级商户结算周期和自动提现预留金额设置修改
     */
    CMS042_SETTLEMENT_CONFIG_MODIFY(
        "二级商户结算周期和自动提现预留金额设置修改",
        "CMS042",
        "1.0.0",
        "CMS",
        MsfpaySettlementConfigModifyRequest.class,
        MsfpaySettlementConfigModifyResponse.class
    ),

    /**
     * CMS043-查询二级商户结算设置修改流水状态
     */
    CMS043_SETTLEMENT_CONFIG_QUERY(
        "查询二级商户结算设置修改流水状态",
        "CMS043",
        "1.0.0",
        "CMS",
        MsfpaySettlementConfigQueryRequest.class,
        MsfpaySettlementConfigQueryResponse.class
    ),

    /**
     * CMS044-商户开户意愿确认查询
     */
    CMS044_MERCHANT_CONFIRM(
        "商户开户意愿确认查询",
        "CMS044",
        "1.0.0",
        "CMS",
        MsfpayMerchantConfirmRequest.class,
        MsfpayMerchantConfirmResponse.class
    ),

    /**
     * CMS049-申请注册会员
     */
    CMS049_MEMBER_REGISTER(
        "申请注册会员",
        "CMS049",
        "1.0.0",
        "CMS",
        MsfpayMemberRegisterRequest.class,
        MsfpayMemberRegisterResponse.class
    ),

    /**
     * CMS050-会员信息查询
     */
    CMS050_MEMBER_INFO_QUERY(
        "会员信息查询",
        "CMS050",
        "1.0.0",
        "CMS",
        MsfpayMemberInfoQueryRequest.class,
        MsfpayMemberInfoQueryResponse.class
    ),

    /**
     * CMS051-二级商户项目账户管理
     */
    CMS051_PROJECT_ACCOUNT_MANAGE(
        "二级商户项目账户管理",
        "CMS051",
        "1.0.0",
        "CMS",
        MsfpayProjectAccountManageRequest.class,
        MsfpayProjectAccountManageResponse.class
    ),

    /**
     * CMS058-查询平台商户配置参数信息
     */
    CMS058_PLATFORM_CONFIG_QUERY(
        "查询平台商户配置参数信息",
        "CMS058",
        "1.0.0",
        "CMS",
        MsfpayPlatformConfigQueryRequest.class,
        MsfpayPlatformConfigQueryResponse.class
    ),

    /**
     * CMS059-创建手续费补贴红包
     */
    CMS059_FEE_SUBSIDY_COUPON_CREATE(
        "创建手续费补贴红包",
        "CMS059",
        "1.0.0",
        "CMS",
        MsfpayFeeSubsidyCouponCreateRequest.class,
        MsfpayFeeSubsidyCouponCreateResponse.class
    ),

    /**
     * CMS060-自定义分账业务申请
     */
    CMS060_CUSTOM_SPLIT_APPLY(
        "自定义分账业务申请",
        "CMS060",
        "1.0.0",
        "CMS",
        MsfpayCustomSplitApplyRequest.class,
        MsfpayCustomSplitApplyResponse.class
    ),
    ;
    
    /**
     * 接口名称
     */
    private final String name;
    
    /**
     * 交易编码
     */
    private final String trancode;
    
    /**
     * 接口版本
     */
    private final String version;
    
    /**
     * 接口类型
     */
    private final String interfaceType;
    
    /**
     * 请求业务参数的Class类型
     */
    private final Class requestClass;
    
    /**
     * 响应业务参数的Class类型
     */
    private final Class responseClass;
    
    MsfpayMerchantApiDefinitionEnum(String name,
            String trancode,
            String version,
            String interfaceType,
            Class requestClass,
            Class responseClass) {
        this.name = name;
        this.trancode = trancode;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }
    
    @Override
    public String getApiURI() {
        return trancode;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
