package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS048-会员分账响应
 */
@Data
public class MsfpayMemberSplitResponse extends MsfpayBizResponse {

    /**
     * 到账银行卡号
     * 必填: 是
     * 长度: 32
     */
    private String cardNo;

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     * 说明: 原样返回
     */
    private String merid;

    /**
     * 会员编号
     * 必填: 是
     * 长度: 12
     * 说明: 原样返回
     */
    private String memUserId;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     * 说明: 原样返回
     */
    private String prno;

    /**
     * 交易状态
     * 必填: 是
     * 长度: 12
     * 说明: 00成功 01失败 02处理中
     */
    private String state;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 14,2
     * 说明: 原样返回
     */
    private BigDecimal tranamt;

    /**
     * 提现渠道响应信息
     * 必填: 否
     * 长度: 128
     */
    private String chlResMsg;
}
