package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS036-商户终端信息报备请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayTerminalInfoReportRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 子商户公众账号ID
     * 必填: 否
     * 长度: 32
     * 说明: 按需填写。微信分配的子商户公众账号ID
     */
    private String subappid;

    /**
     * 通道类型
     * 必填: 是
     * 长度: 32
     * 说明: WEIXIN 微信 ALI支付宝 HUABEI花呗分期
     */
    @NotBlank(message = "通道类型不能为空")
    private String chltype;

    /**
     * 操作标识
     * 必填: 是
     * 长度: 2
     * 说明: 00：新增； 01：修改； 02：启用 03：停用 04：注销
     */
    @NotBlank(message = "操作标识不能为空")
    private String operationId;

    /**
     * 商户终端识别码
     * 必填: 是
     * 长度: 50
     * 说明: 商户侧终端唯一标识。需保证该商户下唯一
     */
    @NotBlank(message = "商户终端识别码不能为空")
    private String deviceId;

    /**
     * 设备类型
     * 必填: 是
     * 长度: 2
     * 说明: 01自动柜员机 04智能POS 08手机POS 09刷脸付终端 10条码支付受理终端 11辅助受理终端 12行业终端 13MIS终端
     */
    @NotBlank(message = "设备类型不能为空")
    private String deviceType;

    /**
     * 终端序列号
     * 必填: 否
     * 长度: 50
     * 说明: 终端类型为04、08、09或10时，必须填写终端序列号
     */
    private String serialNum;

    /**
     * 终端布放地址详细地址
     * 必填: 是
     * 长度: 30
     * 说明: 详细地址长度控制在30个汉字以内
     */
    @NotBlank(message = "终端布放地址详细地址不能为空")
    private String deviceAddress;

    /**
     * 终端布放地址省编码
     * 必填: 是
     * 长度: 6
     * 说明: 见附录信息
     */
    @NotBlank(message = "终端布放地址省编码不能为空")
    private String provinceCode;

    /**
     * 终端布放地址市编码
     * 必填: 是
     * 长度: 6
     * 说明: 见附录信息
     */
    @NotBlank(message = "终端布放地址市编码不能为空")
    private String cityCode;

    /**
     * 终端布放地址区编码
     * 必填: 是
     * 长度: 6
     * 说明: 见附录信息
     */
    @NotBlank(message = "终端布放地址区编码不能为空")
    private String districtCode;

    /**
     * 终端机具型号
     * 必填: 是
     * 长度: 20
     */
    @NotBlank(message = "终端机具型号不能为空")
    private String trmDevcMdl;
}
