package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS044-优惠券查询请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayCouponQueryRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 优惠交易码
     * 必填: 是
     * 长度: 6
     * 说明: 准备使用此优惠的交易码 CAS002： 快捷支付；CAS030：协议支付
     */
    @NotBlank(message = "优惠交易码不能为空")
    private String coupontrancode;

    /**
     * 卡号
     * 必填: 是
     * 长度: 32
     * 说明: 交易卡号
     */
    @NotBlank(message = "卡号不能为空")
    private String cardno;

    /**
     * 身份证号
     * 必填: 否
     * 长度: 18
     * 说明: 活动限制身份证时需上送
     */
    private String idNo;

    /**
     * 手机号
     * 必填: 否
     * 长度: 11
     * 说明: 活动限制手机号时需上送
     */
    private String phoneNo;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 14,2
     * 说明: 交易金额
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 用户渠道标识
     * 必填: 否
     * 长度: 32
     * 说明: 同CAS016 subappid
     */
    private String subappid;

    /**
     * 用户标识
     * 必填: 否
     * 长度: 32
     * 说明: 同CAS016 openid
     */
    private String openid;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
