package com.fshows.msfpay.client;

import cn.hutool.http.Header;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.fshows.msfpay.apienum.MsfpayAutoSignApiDefinitionEnum;
import com.fshows.msfpay.client.model.MsfpayAutoSignPythonConfigModel;
import com.fshows.msfpay.constant.MsfpayConstant;
import com.fshows.msfpay.request.MsfpayBizRequest;
import com.fshows.msfpay.response.MsfpayBaseResponse;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.util.Map;

@Slf4j
public class MsfpayAutoSignPythonClient extends AbstractApiClient<MsfpayBizRequest, MsfpayBaseResponse, MsfpayAutoSignApiDefinitionEnum> {

    public MsfpayAutoSignPythonClient(MsfpayAutoSignPythonConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }


    @Override
    protected ApiRequestModel buildApiRequestModel(MsfpayBizRequest request, DefaultRequestContext context) {
        MsfpayAutoSignPythonConfigModel configModel = (MsfpayAutoSignPythonConfigModel) context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(configModel.getApiParentURL());
        apiRequestModel.setContentType(MsfpayConstant.Http.CONTENT_TYPE_FORM);
        String requestJson = JSON.toJSONString(request);
        Map<String, String> map = JSON.parseObject(requestJson, new TypeReference<Map<String, String>>() {
        });
        apiRequestModel.setRequestForm(map);
        return apiRequestModel;
    }

    @Override
    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName(MsfpayConstant.ClientInfo.CLIENT_NAME);
        clientInfoModel.setClientCode(MsfpayConstant.ClientInfo.CLIENT_CODE);
        return clientInfoModel;
    }

    @Override
    protected MsfpayBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        MsfpayBaseResponse baseResponse = new MsfpayBaseResponse();
        baseResponse.setCode(MsfpayConstant.SignResponseField.SUCCESS_CODE);
        baseResponse.setMsg(MsfpayConstant.SignResponseField.MSG);

        IResponseDefinition iResponseDefinition = JSON.parseObject(apiResponseModel.getResponseBody(), requestContext.getIApiDefinition().getResponseClass());
        baseResponse.setiResponseDefinition(iResponseDefinition);
        return baseResponse;
    }

    @Override
    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
        String body = HttpUtil.createPost(apiClientConfig.getApiParentURL())
                .header(Header.CONTENT_TYPE, MsfpayConstant.Http.CONTENT_TYPE_FORM)
                .charset(apiClientConfig.getCharset())
                .timeout(apiClientConfig.getReadTimeout())
                .formStr(apiRequestModel.getRequestForm())
                .execute().body();
        ApiResponseModel apiResponseModel = new ApiResponseModel();
        apiResponseModel.setResponseBody(body);
        return apiResponseModel;
    }

    @Override
    public MsfpayBaseResponse execute(MsfpayBizRequest request, MsfpayAutoSignApiDefinitionEnum apiDefinition) throws FsApiException {
        return doExecute(request, apiDefinition);
    }

    @Override
    public MsfpayBaseResponse execute(MsfpayBizRequest request, MsfpayAutoSignApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return doExecute(request, apiDefinition, configModel);
    }

    @Override
    protected MsfpayBaseResponse doExecute(MsfpayBizRequest request, MsfpayAutoSignApiDefinitionEnum iApiDefinition, DefaultClientConfigModel customConfig) throws FsApiException {
        long beginTime = System.currentTimeMillis();

        DefaultRequestContext requestContext = buildRequestContext(iApiDefinition, request, customConfig);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;

        try {
            // 入参数校验
            checkParam(request, requestContext);
            // 构建请求数据
            apiRequestModel = buildApiRequestModel(request, requestContext);
            LogUtil.info(log, "{} >> 执行请求开始 >> iApiDefinition={}, request={}", getClientInfo().getClientDesc(), iApiDefinition, JSONObject.toJSONString(apiRequestModel.getParamMap()));
            // 请求开始时间
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = httpRequest(apiRequestModel, requestContext);
            // 请求结束时间
            long reqEndTime = System.currentTimeMillis();
            // 构建响应数据
            MsfpayBaseResponse response = buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info(log, "{} >> 执行请求结束 >> url={}, method={}, request={}, response={}, totalcost={}ms, reqcost={}ms",
                    requestContext.getClientInfoModel().getClientDesc(),
                    apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString(apiRequestModel.getParamMap()),
                    JSONObject.toJSONString(response), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime);
            return response;
        } catch (FsApiException e) {
            LogUtil.error(log, "{} >> 请求业务异常 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", e,
                    requestContext.getClientInfoModel().getClientDesc(),
                    iApiDefinition, JSONObject.toJSONString(request), JSONObject.toJSONString(apiRequestModel), JSONObject.toJSONString(apiResponseModel));
            throw e;
        } catch (Exception e) {
            LogUtil.error(log, "{} >> 请求未知异常 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", e,
                    requestContext.getClientInfoModel().getClientDesc(),
                    iApiDefinition, JSONObject.toJSONString(request), JSONObject.toJSONString(apiRequestModel), JSONObject.toJSONString(apiResponseModel));
            throw new FsApiException("请求未知异常", e);
        }
    }

    @Override
    protected DefaultRequestContext buildRequestContext(MsfpayAutoSignApiDefinitionEnum iApiDefinition, MsfpayBizRequest request, DefaultClientConfigModel customConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setIApiDefinition(iApiDefinition);

        MsfpayAutoSignPythonConfigModel config = new MsfpayAutoSignPythonConfigModel();
        MsfpayAutoSignPythonConfigModel clientConfig = (MsfpayAutoSignPythonConfigModel) this.apiClientConfig;

        config.setApiParentURL(clientConfig.getApiParentURL());
        config.setCharset(clientConfig.getCharset());
        config.setTimeout(clientConfig.getTimeout());

        context.setApiClientConfig(config);
        context.setClientInfoModel(getClientInfo());
        return context;
    }
}
