/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.msfpay.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fshows.msfpay.client.model.MsfpayMerchantClientConfigModel;
import com.fshows.msfpay.utils.SM2Utils;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import msfpay.cfca.sadk.util.Base64;
import msfpay.cfca.sadk.util.CertUtil;
import msfpay.cfca.sadk.x509.certificate.X509Cert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsfpayDecryptClient {
    private static final Logger log = LoggerFactory.getLogger(MsfpayDecryptClient.class);
    private PrivateKey merchantSignPrivateKey;
    private PrivateKey merchantEncPrivateKey;
    private X509Cert platformEncCert;
    private X509Cert platformSignCert;
    private X509Cert merchantEncCert;
    private X509Cert merchantSignCert;

    public MsfpayDecryptClient(MsfpayMerchantClientConfigModel apiClientConfig) throws Exception {
        this.initCertificatesAndKeys(apiClientConfig);
    }

    private void initCertificatesAndKeys(MsfpayMerchantClientConfigModel config) throws Exception {
        try {
            this.merchantSignPrivateKey = SM2Utils.getPrivateKeyFromSM2(config.getMerchantSignPath(), config.getMerchantSignPwd());
            this.merchantEncPrivateKey = SM2Utils.getPrivateKeyFromSM2(config.getMerchantEncPath(), config.getMerchantEncPwd());
            String platformEncCertContent = new String(Files.readAllBytes(Paths.get(config.getPlatformEncCertPath(), new String[0]))).replaceAll("\\n", "").replace("\\r", "");
            this.platformEncCert = new X509Cert(platformEncCertContent.getBytes("UTF-8"));
            String platformSignCertContent = new String(Files.readAllBytes(Paths.get(config.getPlatformSignCertPath(), new String[0]))).replaceAll("\\n", "").replace("\\r", "");
            this.platformSignCert = new X509Cert(platformSignCertContent.getBytes("UTF-8"));
            this.merchantEncCert = CertUtil.getCertFromSM2((String)config.getMerchantEncPath());
            this.merchantSignCert = CertUtil.getCertFromSM2((String)config.getMerchantSignPath());
            log.info("\u8bc1\u4e66\u548c\u5bc6\u94a5\u521d\u59cb\u5316\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u8bc1\u4e66\u548c\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
            throw new Exception("\u521d\u59cb\u5316\u8bc1\u4e66\u548c\u5bc6\u94a5\u5931\u8d25", e);
        }
    }

    public String decrypt(String encryptedData) {
        try {
            LogUtil.info((Logger)log, (String)"\u3010msfpay-sdk\u3011\u4e2d\u6295\u652f\u4ed8 >> \u8fd4\u53c2\u89e3\u5bc6\u5f00\u59cb >> encryptedData={}", (Object[])new Object[]{encryptedData});
            byte[] decryptedData = SM2Utils.openEvelopedMessage(encryptedData, this.merchantEncPrivateKey, this.merchantEncCert, SM2Utils.session);
            String msg = new String(decryptedData, "UTF-8");
            JSONObject Obj = JSON.parseObject((String)msg, (Feature[])new Feature[]{Feature.OrderedField});
            String messageStr = Obj.getString("message");
            JSONObject messageObj = JSON.parseObject((String)messageStr, (Feature[])new Feature[]{Feature.OrderedField});
            String dataStr = messageObj.getString("data");
            JSONObject body = JSON.parseObject((String)dataStr, (Feature[])new Feature[]{Feature.OrderedField});
            String bodyStr = body.getString("body");
            String headStr = body.getString("head");
            JSONObject headObj = JSON.parseObject((String)headStr, (Feature[])new Feature[]{Feature.OrderedField});
            String signStr = messageObj.getString("sign");
            boolean verify = SM2Utils.P7VerifyMessageDetach(new String(Base64.encode((byte[])dataStr.getBytes("UTF-8"))), signStr, this.platformSignCert, SM2Utils.session);
            if (!verify) {
                throw new FsApiException("\u9a8c\u7b7e\u5931\u8d25");
            }
            JSONObject jsonObject = JSON.parseObject((String)bodyStr);
            jsonObject.put("respcode", headObj.get((Object)"respcode"));
            jsonObject.put("respmsg", headObj.get((Object)"respmsg"));
            LogUtil.info((Logger)log, (String)"\u3010msfpay-sdk\u3011\u4e2d\u6295\u652f\u4ed8 >> \u8fd4\u53c2\u89e3\u5bc6\u7ed3\u675f >> encryptedData={}\uff0c\u53c2\u6570\u660e={}", (Object[])new Object[]{encryptedData, jsonObject.toJSONString()});
            return jsonObject.toJSONString();
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new FsApiException("\u89e3\u5bc6\u5931\u8d25");
        }
    }
}

