package com.fshows.msfpay.utils;

import com.fshows.msfpay.constant.MsfpayConstant;
import msfpay.cfca.sadk.x509.certificate.X509Cert;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author songjian * @version MsfpayUtil.java, v 0.1 2025-08-15 10:34 songjian
 */
public class MsfpayUtil {
    /**
     * 获取当前指定格式时间
     * @param  pattern
     * @return String
     */
    public static String getCurrentDateTime(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(new Date());
    }

    /**
     * 获取交易单号
     * @param  platmerid
     * @return String
     */
    public static String generateTranflow(String platmerid) {
        String dateTime = getCurrentDateTime(MsfpayConstant.DateTimeFormat.DATETIME_FORMAT);
        int random = (int) (Math.random() * 900) + 100;
        return platmerid + dateTime + random;
    }

    /**
     * 获取X509Cert
     * @param  path
     * @return X509Cert
     */
    public static X509Cert getX509Cert(String path) throws Exception {
        if(StringUtils.isEmpty(path)){
            return null;
        }
        String platformEncCertContent = new String(Files.readAllBytes(Paths.get(path)))
                .replaceAll(MsfpayConstant.StringPattern.LINE_FEED, MsfpayConstant.StringPattern.EMPTY)
                .replace(MsfpayConstant.StringPattern.CARRIAGE_RETURN, MsfpayConstant.StringPattern.EMPTY);
        return new X509Cert(platformEncCertContent.getBytes(MsfpayConstant.Http.CHARSET_UTF8));
    }
}
