package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayFeeSubsidyRuleItemRequest;
import com.fshows.msfpay.request.item.MsfpayGoodsDetailRequest;
import com.fshows.msfpay.request.item.MsfpayProductItemListRequest;
import com.fshows.msfpay.request.item.MsfpayProfitItemListRequest;
import com.fshows.msfpay.request.item.MsfpayTerminalInfoRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

/**
 * CAS016-条码支付请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayBarcodePayRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     * 示例: CM3000057716
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 支付方式
     * 必填: 是
     * 长度: 32
     * 05：微信公众号/小程序
     * 06：支付宝正扫
     * 07：支付宝服务窗/小程序
     * 08：微信刷卡(付款码)
     * 09：支付宝刷卡(付款码)
     * 12：银联正扫
     * 13：银联反扫
     * 14：银联APP支付
     * 15：花呗分期正扫
     * 16：花呗分期反扫
     * 22：银联js支付
     * 24：云微小程序支付
     */
    @NotBlank(message = "支付方式不能为空")
    private String paytype;

    /**
     * 交易方式
     * 必填: 否
     * 长度: 32
     * 预下单：precreate，当使用小程序插件支付时使用
     */
    private String tradetype;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 以元单位，小数部分四舍五入保留2位小数
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 服务器回调地址(商户提供)
     * 必填: 是
     * 长度: 128
     * 订单支付成功之后作为服务器回调的地址,触发异步响应报文
     */
    @NotBlank(message = "服务器回调地址不能为空")
    private String serverurl;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 以元单位，小数部分四舍五入保留2位小数
     */
     private BigDecimal patfee;

    /**
     * 平台补贴手续费
     * 必填: 否
     * 长度: 14,2
     * 以元单位，小数部分四舍五入保留2位小数，不能大于平台手续费
     */
    private BigDecimal patsubsidyfee;

    /**
     * 分账类型
     * 必填: 是
     * 长度: 2
     * 00 按比例分账
     * 01 按金额分账
     */
    private String profittype;

    /**
     * 分账信息
     * 必填: 是
     * 长度: 3000
     * JSON格式的分账信息
     * 对应对象: MsfpayProfitItemRequest
     */
    private MsfpayProfitItemListRequest profitlist;

    /**
     * 商品信息
     * 必填: 是
     * 长度: 255
     * JSON格式的商品信息
     * 对应对象: MsfpayProductItemListRequest
     */
    @NotNull(message = "商品信息不能为空")
    private MsfpayProductItemListRequest productlist;

    /**
     * Appid
     * 必填: 否
     * 长度: 32
     * 公众号、小程序、云微小程序必输
     */
    private String subappid;

    /**
     * openid
     * 必填: 否
     * 长度: 128
     * 公众号、小程序和支付宝服务窗支付必输
     * 微信：openid，支付宝：userid
     */
    private String openid;

    /**
     * 付款码
     * 必填: 否
     * 长度: 32
     * 刷卡交易必输
     * 微信付款码：18位纯数字，以10、11、12、13、14、15开头
     * 支付宝付款码：16-24位纯数字，以25-30开头
     */
    private String authcode;

    /**
     * 备注
     * 必填: 否
     * 长度: 128
     * 用于展示付款用途
     */
    private String remark;

    /**
     * 终端ip
     * 必填: 是
     * 长度: 16
     * 调用支付API的机器IP
     */
    private String spbillcreateip;

    /**
     * 设备信息
     * 必填: 否
     * 长度: 32
     * 银联反扫必填（8位数字）
     */
    private String deviceinfo;

    /**
     * 指定支付方式
     * 必填: 否
     * 长度: 32
     * 1 不允许使用信用卡，默认为0
     */
    private String limitpay;

    /**
     * 订单超时时间
     * 必填: 否
     * 长度: 2
     * 1-30之间（含）的正整数，单位为分钟，默认30分钟
     */
    private Integer orderexpiretime;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 银行卡类型
     * 必填: 否
     * 长度: 2
     * 用于区分不同卡类型的手续费
     */
    private String bankcardtype;

    /**
     * 订单优惠标识
     * 必填: 否
     * 长度: 32
     * 用于微信代金券
     */
    private String goodstag;

    /**
     * 商品详情
     * 必填: 否
     * 长度: 1024
     * 微信单品优惠活动必传，JSON格式
     * MsfpayGoodsDetailRequest
     */
    private MsfpayGoodsDetailRequest goodsdetail;

    /**
     * 花呗分期笔数
     * 必填: 否
     * 长度: 2
     * 3: 3期，6: 6期，12: 12期
     * 支付方式为15花呗分期正扫或16花呗分期反扫时必填
     */
    private String installmentNum;

    /**
     * 商户手续费承担比例
     * 必填: 否
     * 长度: 3
     * 0：用户承担手续费；100：商家承担手续费
     */
    private String feePercent;

    /**
     * 手续费补贴费率明细
     * 必填: 否
     * JSON格式的手续费补贴费率明细
     * 对应对象: MsfpayFeeSubsidyRuleItemRequest
     */
    private List<MsfpayFeeSubsidyRuleItemRequest> feeSubsidyRuleList;

    /**
     * 终端信息
     * 必填: 否
     * JSON格式的终端信息
     * （支付宝/微信）反扫、刷卡必输
     */
    private MsfpayTerminalInfoRequest terminalInfo;

    /**
     * 前端成功通知地址
     * 必填: 否
     * 长度: 128
     * 银联js支付完成后会跳转到此地址
     */
    private String frontUrl;

    /**
     * 前端失败通知地址
     * 必填: 否
     * 长度: 128
     * 与frontUrl同时出现
     */
    private String frontFailUrl;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 语音播报控制
     * 必填: 否
     * 长度: 1
     * Y：播报，N:不播报（默认值）
     */
    private String voiceControl;

    /**
     * 手机号码
     * 必填: 否
     * 长度: 13
     */
    private String mobileno;
}
