package com.fshows.msfpay.response;

import com.fshows.msfpay.response.item.MsfpayActCouponDetailsResponse;
import com.fshows.msfpay.response.item.MsfpayActDetailsResponse;
import lombok.Data;

import java.util.List;

/**
 * CMS059-创建手续费补贴红包响应
 */
@Data
public class MsfpayFeeSubsidyCouponCreateResponse extends MsfpayBizResponse {

    /**
     * 申请流水号
     * 必填: 是
     * 长度: 32
     * 说明: 本次申请的唯一流水号
     */
    private String reqFlow;

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     * 说明: 申请活动的商户号
     */
    private String merid;

    /**
     * 活动补贴信息
     * 必填: 否
     * 说明: 活动申请的处理结果列表
     */
    private List<MsfpayActDetailsResponse> actDetails;

    /**
     * 红包明细信息
     * 必填: 否
     * 说明: 红包创建的详细信息列表
     */
    private List<MsfpayActCouponDetailsResponse> actCouponDetails;
}
