package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * CMS016-结算卡绑定确认请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpaySettleCardConfirmRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 账户号码
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "账户号码不能为空")
    private String accountno;

    /**
     * 账户类型
     * 必填: 是
     * 长度: 2
     * 说明: 见附录
     */
    @NotBlank(message = "账户类型不能为空")
    private String accounttype;

    /**
     * 银行预留手机号
     * 必填: 否
     * 长度: 13
     * 说明: 对私必填
     */
    private String prebankmobile;

    /**
     * 金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 账户类型为对公校验金打款额，对私金额输入0
     */
    private BigDecimal tranamt;

    /**
     * 验证令牌
     * 必填: 是
     * 长度: 50
     * 说明: 必填，由CMS012返回
     */
    @NotBlank(message = "验证令牌不能为空")
    private String phonetoken;

    /**
     * 验证码
     * 必填: 否
     * 长度: 10
     * 说明: 对私必填
     */
    private String phonevercode;
}
