package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayTransferItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * CAS017-平台转账请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayPlatformTransferRequest extends MsfpayBizRequest {

    /**
     * 收款人列表
     * 必填: 是
     * 长度: 255
     * 说明: {'transferList':[{'outuserid':'20180706103910','customerType':'1','transferamt':'0.04'},{'outuserid':'CM3000038826','customerType':'2','transferamt':'0.02','prno':''}]}
     * 对应对象: MsfpayTransferItemListRequest
     * 注意：收款人为二级商户时，customerType上送2
     */
    @NotNull(message = "收款人列表不能为空")
    private MsfpayTransferItemListRequest transferList;

    /**
     * 备注
     * 必填: 是
     * 长度: 100
     */
    @NotBlank(message = "备注不能为空")
    private String remark;

    /**
     * 服务器回调地址
     * 必填: 是
     * 长度: 128
     * 说明: 订单成功之后作为服务器回调的地址
     */
    @NotBlank(message = "服务器回调地址不能为空")
    private String serverurl;
}
