package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS062-查询提现明细数据响应
 */
@Data
public class MsfpayWithdrawDetailQueryResponse extends MsfpayBizResponse {

    /**
     * 明细总条数
     * 必填: 是
     */
    private Integer totalnum;

    /**
     * 提现总笔数
     * 必填: 是
     */
    private Integer withdrawtotalnum;

    /**
     * 提现总金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal withdrawtotalamt;

    /**
     * 提现总手续费
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal withdrawtotalfee;

    /**
     * 明细数据
     * 必填: 是
     * 说明: gzip文件，base64编码
     */
    private String data;
}
