package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS038-分期支付响应
 */
@Data
public class MsfpayInstallmentPayResponse extends MsfpayBizResponse {

    /**
     * 商户名称
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 银行卡被扣费的金额,保留小数2位。整数位最大为14位。
     */
    private BigDecimal tranamt;

    /**
     * 交易完成时间
     * 必填: 否
     * 长度: 17
     * 说明: 交易成功时返回，订单生成时间，格式为 yyyyMMddHHmmssSSS。如2009年12月25日9点10分10秒表示为20091225091010002
     */
    private String finishtime;

    /**
     * 短卡号
     * 必填: 否
     * 长度: 10
     * 说明: 支付卡的短卡号，支付成功返回
     */
    private String storablecardno;

    /**
     * 银行编码
     * 必填: 否
     * 长度: 8
     * 说明: 支付银行编码，支付成功返回
     */
    private String bankcord;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
