package com.fshows.msfpay.response;

import com.fshows.msfpay.response.item.MsfpayCouponInfoResponse;
import com.fshows.msfpay.response.item.MsfpayFeeRateInfoResponse;
import com.fshows.msfpay.response.item.MsfpayThirdPartySubsidyInfoResponse;
import lombok.Data;

import java.util.List;

/**
 * CMS034-手续费补贴查询响应
 */
@Data
public class MsfpayFeeSubsidyQueryResponse extends MsfpayBizResponse {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 活动编码
     * 必填: 是
     * 长度: 32
     * 说明: JSON格式的费率规则列表
     */
    private String activityCode;

    /**
     * 费率规则列表
     * 必填: 是
     * 长度: 2000
     * 说明: JSON格式的费率规则列表
     */
    private MsfpayFeeRateInfoResponse rules;

    /**
     * 第三方补贴相关数据
     * 必填: 是
     * 长度: 2000
     * 说明: JSON格式的费率规则列表
     */
    private MsfpayThirdPartySubsidyInfoResponse thirdSubsidyInfo;

    /**
     * 红包相关数据
     * 必填: 是
     * 长度: 2000
     * 说明: JSON格式的费率规则列表
     */
    private List<MsfpayCouponInfoResponse> coupons;
}
