/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.msfpay.utils;

import com.fshows.msfpay.utils.SM2EnvelopeUtil;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import msfpay.cfca.sadk.lib.crypto.JCrypto;
import msfpay.cfca.sadk.lib.crypto.Session;
import msfpay.cfca.sadk.util.Base64;
import msfpay.cfca.sadk.util.KeyUtil;
import msfpay.cfca.sadk.util.Signature;
import msfpay.cfca.sadk.x509.certificate.X509Cert;

public class SM2Utils {
    public static Session session;

    public static byte[] envelopeMessage(String sourceString, String symmetricAlgorithm, X509Cert cert) throws Exception {
        byte[] sourceData = sourceString.getBytes(StandardCharsets.UTF_8);
        return SM2EnvelopeUtil.envelopeMessage(sourceData, symmetricAlgorithm, new X509Cert[]{cert}, session);
    }

    public static byte[] openEvelopedMessage(String base64EnvelopeMessage, PrivateKey privateKey, X509Cert recipientCert, Session session) throws Exception {
        return SM2EnvelopeUtil.openEvelopedMessage(base64EnvelopeMessage.getBytes(StandardCharsets.UTF_8), privateKey, recipientCert, session);
    }

    public static String P7SignMessageDetach(String signAlg, String base64SourceString, PrivateKey privateKey, X509Cert cert, Session session) throws Exception {
        byte[] sourceData = Base64.decode((String)base64SourceString);
        Signature signature = new Signature();
        byte[] base64Bytes = signature.p7SignMessageDetach(signAlg, sourceData, privateKey, cert, session);
        return new String(base64Bytes);
    }

    public static boolean P7VerifyMessageDetach(String base64SourceString, String base64SignatureString, X509Cert publicCert, Session session) throws Exception {
        byte[] sourceData = Base64.decode((String)base64SourceString);
        byte[] signatureData = Base64.decode((String)base64SignatureString);
        Signature signature = new Signature();
        return signature.p7VerifyMessageDetach(sourceData, signatureData, session);
    }

    public static PrivateKey getPrivateKeyFromSM2(String sm2Path, String sm2Pwd) throws Exception {
        return KeyUtil.getPrivateKeyFromSM2((String)sm2Path, (String)sm2Pwd);
    }

    static {
        try {
            JCrypto crypto = JCrypto.getInstance();
            crypto.initialize("JSOFT_LIB", null);
            session = crypto.openSession("JSOFT_LIB");
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316SM2\u4f1a\u8bdd\u5931\u8d25", e);
        }
    }
}

