package com.fshows.msfpay.response.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author songjian * @version MsfpayTransactionRefundDetailItemResponse.java, v 0.1 2025-08-06 17:42 songjian
 */
@Data
public class MsfpayTransactionRefundDetailItemResponse {
    /**
     * 渠道退款单号
     * 必填: 否
     * 长度: 32
     */
    private String refundId;

    /**
     * 退款状态
     * 必填: 否
     * 长度: 6
     * 说明: 01退款成功 02退款处理中 03退款失败
     */
    private String refundStatus;

    /**
     * 退款到账时间
     * 必填: 否
     * 长度: 18
     * 说明: yyyyMMddHHmmssSSS
     */
    private String refundPayTime;

    /**
     * 应退金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal settleRefundFee;

    /**
     * 实退金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal refundCashAmt;

    /**
     * 代金券退款总金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal couponRefundFee;

    /**
     * 退款渠道
     * 必填: 否
     * 长度: 32
     * 说明: ORIGINAL—原路退款;
     *       BALANCE—退回到余额;
     *       OTHER_BALANCE—原账户异常退到其他余额账户;
     *       OTHER_BANKCARD—原银行卡异常退到其他银行卡
     */
    private String refundChannel;

    /**
     * 退款入账账户信息
     * 必填: 否
     * 长度: 64
     * 说明: 微信:
     *       银行卡:{银行名称}{卡类型}{卡尾号};
     *       用户零钱;
     *       退还商户;
     *       退回支付用户零钱通;
     */
    private String refundRecvAccout;
}
