package com.fshows.msfpay.response.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author songjian * @version MsfpayThirdPartySubsidyInfoResponse.java, v 0.1 2025-08-06 20:06 songjian
 */
@Data
public class MsfpayThirdPartySubsidyInfoResponse {
    /**
     * 营销账户号码
     * 必填: 是
     * 长度: 32
     */
    public String budgetAcctNo;

    /**
     * 营销账户名称
     * 必填: 是
     * 长度: 255
     */
    public String budgetAcctName;

    /**
     * 营销账户余额
     * 必填: 是
     * 类型: Number(14,2)
     * 长度: 16
     */
    public BigDecimal budgetAcctBalance;

    /**
     * 营销账户冻结余额
     * 必填: 否
     * 类型: Number(14,2)
     * 长度: 16
     */
    public BigDecimal budgetAcctPledgedAmt;

    /**
     * 营销账户状态
     * 必填: 是
     * 长度: 1
     * 说明: A：正常 B：销户 C：冻结 D：止付
     */
    public String budgetAcctStatus;

    /**
     * 活动有效期开始时间
     * 必填: 是
     * 长度: 10
     * 格式: yyyy-MM-dd
     */
    public String startDate;

    /**
     * 活动有效期截止日期
     * 必填: 是
     * 长度: 10
     * 格式: yyyy-MM-dd
     */
    public String endDate;

    /**
     * 活动状态
     * 必填: 是
     * 长度: 2
     * 说明: 00:可用 01:不可用 02:待审核 03:审核拒绝
     */
    public String activityState;
}
