package com.fshows.msfpay.response.item;

import lombok.Data;

/**
 * 分账信息项
 */
@Data
public class MsfpayProfitItemResponse {

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     * 示例: CF3000038556
     */
    private String merid;

    /**
     * 分账比例
     * 必填: 是
     * 长度: 10
     * 示例: 0.8
     * 说明: 分账比例，如0.8表示80%
     */
    private String proportion;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     * 示例: 1000000001
     * 说明: 项目编号，非必输。当平台商户配置关闭分账功能后非必输
     */
    private String prno;
} 