package com.fshows.msfpay.response.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author songjian * @version MsfpayFeeRateInfoResponse.java, v 0.1 2025-08-06 20:05 songjian
 */
@Data
public class MsfpayFeeRateInfoResponse {
    /**
     * 费率编号
     * 必填: 是
     * 长度: 32
     */
    public String id;

    /**
     * 支付类型
     * 必填: 是
     * 长度: 12
     * 说明: WEIXIN:微信 ALI:支付宝 UP:银联二维码 HUABEI:花呗分期 QUICKPAY:快捷支付
     */
    public String payType;

    /**
     * 银行卡类型
     * 必填: 否
     * 长度: 2
     * 说明: 01:借记卡 02:贷记卡 99:企业账户(快捷支付时必输)
     */
    public String bankCardType;

    /**
     * 费率值
     * 必填: 是
     * 类型: Number(14,10)
     * 说明: 百分比，最多10位小数
     */
    public BigDecimal subsidyRatio;

    /**
     * 有效期开始日期
     * 必填: 是
     * 长度: 10
     * 格式: yyyy-MM-dd
     */
    public String startDate;

    /**
     * 有效期截止日期
     * 必填: 是
     * 长度: 10
     * 格式: yyyy-MM-dd
     */
    public String endDate;

    /**
     * 状态
     * 必填: 是
     * 长度: 20
     * 说明: USABLE:可用 DISABLE:不可用 EXPIRED:已过期 WAIT_AUDIT:待审核 AUDIT_REJECT:审核拒绝
     */
    public String state;

    /**
     * 备注
     * 必填: 否
     * 长度: 255
     */
    public String remark;
}
