package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS046-转账支付响应
 */
@Data
public class MsfpayTransferPayResponse extends MsfpayBizResponse {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 订单收款账号
     * 必填: 是
     * 长度: 32
     * 说明: 线下转账必填的标识
     */
    private String payeeaccount;

    /**
     * 收款账户名称
     * 必填: 是
     * 长度: 60
     */
    private String payeeaccountname;

    /**
     * 收款银行名称
     * 必填: 是
     * 长度: 60
     */
    private String payeebankname;

    /**
     * 收款银行网点号/分行号
     * 必填: 是
     * 长度: 32
     */
    private String payeebanksiteno;

    /**
     * 收款银行网点名称/分行名称
     * 必填: 是
     * 长度: 60
     */
    private String payeebanksitename;

    /**
     * 收款银行开户地
     * 必填: 是
     * 长度: 60
     */
    private String payeebankopencity;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 单位:元
     */
    private BigDecimal tranamt;

    /**
     * 交易状态
     * 必填: 是
     * 长度: 2
     * 说明: 02交易处理中
     */
    private String transtate;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 匹配方式
     * 必填: 否
     * 长度: 12
     * 说明: PYE:收款账户 RMK:备注
     */
    private String matchmode;

    /**
     * 转账备注
     * 必填: 否
     * 长度: 32
     */
    private String transferRemark;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 说明: 以元单位，小数部分四舍五入保留2位小数.
     */
    private BigDecimal patfee;
}
