package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CMS043-查询二级商户结算设置修改流水状态响应
 */
@Data
public class MsfpaySettlementConfigQueryResponse extends MsfpayBizResponse {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 修改类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：修改结算周期 02：修改预留金额
     */
    private String modifyType;

    /**
     * 结算周期
     * 必填: 否
     * 长度: 2
     */
    private String settlePeriod;

    /**
     * 预留金额
     * 必填: 否
     * 长度: 14,2
     */
    private BigDecimal keepAmt;

    /**
     * 审核备注
     * 必填: 否
     * 长度: 128
     */
    private String auditRemark;

    /**
     * 申请状态
     * 必填: 否
     * 长度: 128
     */
    private String resultCode;

    /**
     * 申请状态描述
     * 必填: 否
     * 长度: 128
     */
    private String resultDesc;

    /**
     * 申请状态
     * 必填: 是
     * 长度: 2
     * 说明: 00 已开通 01 待审核 02 审核拒绝 03 待签 04 已禁用 05 已过期 06 已失效
     */
    private String state;
}
