package com.fshows.msfpay.response;

import lombok.Data;

/**
 * CMS041-二级商户项目管理响应
 */
@Data
public class MsfpayProjectManageResponse extends MsfpayBizResponse {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 处理状态
     * 必填: 是
     * 长度: 2
     * 说明: 00：处理成功 01：处理失败
     */
    private String status;

    /**
     * 账户类型
     * 必填: 否
     * 长度: 2
     */
    private String accounttype;

    /**
     * 账户号码
     * 必填: 否
     * 长度: 32
     */
    private String accountno;

    /**
     * 账户名称
     * 必填: 否
     * 长度: 128
     */
    private String accountname;

    /**
     * 银行名称
     * 必填: 否
     * 长度: 128
     */
    private String bankname;

    /**
     * 银行代码
     * 必填: 否
     * 长度: 8
     */
    private String bankcode;

    /**
     * 开户所在省
     * 必填: 否
     * 长度: 20
     */
    private String bankpro;

    /**
     * 开户所在市
     * 必填: 否
     * 长度: 30
     */
    private String bankcity;

    /**
     * 所属分支行
     * 必填: 否
     * 长度: 32
     * 说明: 分支行编码
     */
    private String branch;
}
