package com.fshows.msfpay.response;

import lombok.Data;

/**
 * CMS044-商户开户意愿确认查询响应
 */
@Data
public class MsfpayMerchantConfirmResponse extends MsfpayBizResponse {

    /**
     * 认证状态
     * 支付宝：
     * AUTHORIZED：已确认
     * UNAUTHORIZED：未确认
     * CLOSED：已销户
     * SMID_NOT_EXIST ： smid不存在
     * 微信：
     * AUTHORIZE_STATE_UNAUTHORIZED：未授权
     * AUTHORIZE_STATE_AUTHORIZED ：已授权
     * 必填: 是
     * 长度: 12
     */
    private String authResult;

    /**
     * 渠道子商户号
     * 原样返回
     * 必填: 是
     * 长度: 32
     * 示例: 521882476
     */
    private String chlmerid;

    /**
     * 中投商户号
     * 原样返回
     * 必填: 是
     * 长度: 32
     * 示例: CM3000057716
     */
    private String merid;
}
