package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS051-会员分账(商户在途资金)响应
 */
@Data
public class MsfpayMemberSplitTransitResponse extends MsfpayBizResponse {

    /**
     * 商户号
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 会员编号
     * 必填: 是
     * 长度: 12
     */
    private String memUserId;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 14,2
     */
    private BigDecimal tranamt;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;

    /**
     * 交易状态
     * 必填: 否
     * 长度: 2
     * 说明: 00成功 01失败 02处理中
     */
    private String state;

    /**
     * 到账银行卡号
     * 必填: 是
     * 长度: 32
     */
    private String cardNo;

    /**
     * 提现渠道响应信息
     * 必填: 否
     * 长度: 128
     */
    private String chlResMsg;
}
