package com.fshows.msfpay.response;

import com.fshows.msfpay.response.item.MsfpayProfitAmtListResponse;
import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS025-额度提现响应
 */
@Data
public class MsfpayCreditWithdrawResponse extends MsfpayBizResponse {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    private String merid;

    /**
     * 结算金额
     * 必填: 是
     * 长度: 16,2
     */
    private BigDecimal amount;

    /**
     * 分账信息
     * 必填: 否
     * 长度: 128
     * 说明: 格式如： "{"profitamtList":[{"merid":"CM3000047819","profitamt":"0.1","prno":"1000000001"},{"merid":"CF3000038788","profitamt":"0.1","prno":"1000000002"}]}"
     * 对应对象: MsfpayProfitAmtListResponse
     */
    private MsfpayProfitAmtListResponse profitamtlist;

    /**
     * 手续费金额
     * 必填: 否
     * 长度: 16,2
     */
    private BigDecimal feeamt;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
