package com.fshows.msfpay.response;

import lombok.Data;

import java.math.BigDecimal;

/**
 * CAS044-优惠券查询响应
 */
@Data
public class MsfpayCouponQueryResponse extends MsfpayBizResponse {

    /**
     * 优惠标识
     * 必填: 是
     * 长度: 32
     * 说明: 后续交易中使用
     */
    private String coupontoken;

    /**
     * 过期时间
     * 必填: 是
     * 长度: 30
     * 说明: 格式：yyyy-MM-ddTHH:mm:ss
     */
    private String exptime;

    /**
     * 优惠金额
     * 必填: 是
     * 长度: 14,2
     */
    private BigDecimal couponamt;

    /**
     * 优惠类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：满减  02:随机立减
     */
    private String coupontype;

    /**
     * 优惠描述
     * 必填: 否
     * 长度: 256
     */
    private String coupondesc;
}
