package com.fshows.msfpay.response;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.ToString;

import java.util.Map;

/**
 * 中投科信支付基础响应类
 */
@ToString
public class MsfpayBaseResponse extends MsfpayBizResponse {
    private IResponseDefinition iResponseDefinition;
    private Message message;

    /**
     * 响应代码
     * 字节长度: String
     * 必填: 是
     */
    private String code;

    /**
     * 响应代码描述
     * 字节长度: String
     * 必填: 是
     */
    private String msg;

    /**
     * 流水号
     */
    private String tranflow;

    public static class Message {
        private Data data;
        private String sign;

        public Data getData() {
            return data;
        }

        public String getSign() {
            return sign;
        }

        public void setData(Data data) {
            this.data = data;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }
    }

    public static class Data {
        private Head head;
        private Map<String, Object> body; // 使用Map接收业务数据

        public Head getHead() {
            return head;
        }

        public Map<String, Object> getBody() {
            return body;
        }

        public void setHead(Head head) {
            this.head = head;
        }

        public void setBody(Map<String, Object> body) {
            this.body = body;
        }

        // 安全获取body字段值
        public Object getBodyField(String key) {
            return body != null ? body.get(key) : null;
        }
    }

    public static class Head {
        private String mertrandate;
        private String mertrantime;
        private String platmerid;
        private String respcode;
        private String respmsg;
        private String trancode;
        private String tranflow;
        private String ztpage;

        // 添加getter方法
        public String getMertrandate() { return mertrandate; }
        public String getMertrantime() { return mertrantime; }
        public String getPlatmerid() { return platmerid; }
        public String getRespcode() { return respcode; }
        public String getRespmsg() { return respmsg; }
        public String getTrancode() { return trancode; }
        public String getTranflow() { return tranflow; }
        public String getZtpage() { return ztpage; }

        public void setMertrandate(String mertrandate) {
            this.mertrandate = mertrandate;
        }

        public void setMertrantime(String mertrantime) {
            this.mertrantime = mertrantime;
        }

        public void setPlatmerid(String platmerid) {
            this.platmerid = platmerid;
        }

        public void setRespcode(String respcode) {
            this.respcode = respcode;
        }

        public void setRespmsg(String respmsg) {
            this.respmsg = respmsg;
        }

        public void setTrancode(String trancode) {
            this.trancode = trancode;
        }

        public void setTranflow(String tranflow) {
            this.tranflow = tranflow;
        }

        public void setZtpage(String ztpage) {
            this.ztpage = ztpage;
        }

        public boolean isSuccess() {
            return "C000000000".equals(respcode);
        }
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getTranflow() {
        return tranflow;
    }

    public void setTranflow(String tranflow) {
        this.tranflow = tranflow;
    }

    // getter方法
    public Message getMessage() {
        return message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public IResponseDefinition getiResponseDefinition() {
        return iResponseDefinition;
    }

    public void setiResponseDefinition(IResponseDefinition iResponseDefinition) {
        this.iResponseDefinition = iResponseDefinition;
    }
}
