package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * 转账信息项
 */
@Data
public class MsfpayTransferItemRequest {

    /**
     * 外部用户号
     * 必填: 是
     * 长度: 32
     * 示例: 20180706103910
     */
    private String outuserid;

    /**
     * 客户类型
     * 必填: 是
     * 长度: 2
     * 示例: 1
     * 说明: 1-个人，2-二级商户
     */
    private String customerType;

    /**
     * 转账金额
     * 必填: 是
     * 长度: 16,2
     * 示例: 0.04
     * 说明: 以元为单位，保留小数2位
     */
    private String transferamt;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     * 示例: 
     * 说明: 项目编号，非必输
     */
    private String prno;
} 