package com.fshows.msfpay.request.item;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 费率区间信息项
 */
@Data
public class MsfpayRateSectionItemRequest {

    /**
     * 费率
     * 必填: 是
     * 长度: 10
     * 示例: 0.05
     * 说明: 费率值，如0.05表示0.05%
     */
    private String fee;

    /**
     * 手续费类型
     * 1:固定金额2::比率
     */
    private String type;

    /**
     * 区间开始金额
     * 单位：元
     */
    private Integer beginInput;

    /**
     * 区间结束金额
     * 单位：元
     */
    private Integer endInput;

    /**
     * 封顶金额
     * 单位：元
     * 银联云闪付和银联APP借记卡支持，其它支付类型不支持
     */
    private BigDecimal endAmt;
}