package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS033-微信授权码查询请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayWechatAuthCodeQueryRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 授权码
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "授权码不能为空")
    private String authcode;

    /**
     * 商户appid
     * 必填: 否
     * 长度: 128
     * 说明: 子商户已绑定appid时此项必填
     */
    private String appid;
}
