package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS008-交易状态查询请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayTransactionQueryRequest extends MsfpayBizRequest {

    /**
     * 原交易交易码
     * 必填: 是
     * 长度: 6
     * 说明: CAS001:网关支付、CAS002:快捷支付、CAS004:收银台支付、CAS005:收银台充值、CAS006:退款、CAS007:提现、CAS010:商户提现、CAS013:快捷充值、CAS014:网关充值、CAS016:条码支付、CAS021:单笔代付、CAS024:额度代付、CAS025:额度提现、CAS030:协议支付、CAS046:转账支付
     */
    @NotBlank(message = "原交易交易码不能为空")
    private String oritrancode;

    /**
     * 原交易订单号
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "原交易订单号不能为空")
    private String oritranflow;

    /**
     * 查询选项
     * 必填: 否
     * 长度: 32
     * 说明: 查询选项，商户通过上送该参数来定制同步需要额外返回的信息字段;目前仅支持传入：refundDetail
     */
    private String queryOption;
}
