package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS027-交易撤销请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayTransactionCancelRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 原交易流水号
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "原交易流水号不能为空")
    private String oritranflow;
}
