package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS043-查询二级商户结算设置修改流水状态请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpaySettlementConfigQueryRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 申请流水号
     * 必填: 是
     * 长度: 32
     * 说明: CMS042的流水号
     */
    @NotBlank(message = "申请流水号不能为空")
    private String oriTranFlow;
}
