package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS012-结算卡绑定请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpaySettleCardBindRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 账户号码
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "账户号码不能为空")
    private String accountno;

    /**
     * 账户类型
     * 必填: 是
     * 长度: 2
     * 说明: 见附录
     */
    @NotBlank(message = "账户类型不能为空")
    private String accounttype;

    /**
     * 账户名称
     * 必填: 是
     * 长度: 30
     * 说明: 个体：对私户需与经营者姓名一致，对公户与商户名一致；企业、小微：需与商户名称一致
     */
    @NotBlank(message = "账户名称不能为空")
    private String accountname;

    /**
     * 银行名称
     * 必填: 否
     * 长度: 128
     * 说明: 对公账户必输
     */
    private String bankname;

    /**
     * 银行代码
     * 必填: 否
     * 长度: 8
     * 说明: 对公账户必输
     */
    private String bankcode;

    /**
     * 开户行所在省
     * 必填: 否
     * 长度: 20
     * 说明: 对公账户必输，不带"省"或"自治区"，如湖南，北京，内蒙古等
     */
    private String bankpro;

    /**
     * 开户行所在市
     * 必填: 否
     * 长度: 30
     * 说明: 对公账户必输，不带"市"字如北京
     */
    private String bankcity;

    /**
     * 银行预留手机号
     * 必填: 否
     * 长度: 13
     * 说明: 对私四要素的绑卡验证用户上送手机号是否为银行预留手机号
     */
    private String prebankmobile;
}
