package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS003-快捷鉴权请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayQuickAuthRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 账号
     * 必填: 是
     * 长度: 32
     * 说明: 银行卡号或者存折号码
     */
    @NotBlank(message = "账号不能为空")
    private String accountno;

    /**
     * 账户名称
     * 必填: 是
     * 长度: 60
     * 说明: 银行卡或者存折上对应的名称
     */
    @NotBlank(message = "账户名称不能为空")
    private String accountname;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 以元单位，银行卡被扣费的金额,保留小数2位。整数位最大为14位。
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 开户证件类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：身份证；目前仅支持身份证
     */
    @NotBlank(message = "开户证件类型不能为空")
    private String certtype;

    /**
     * 证件号
     * 必填: 是
     * 长度: 22
     * 说明: 身份证号码
     */
    @NotBlank(message = "证件号不能为空")
    private String certno;

    /**
     * 手机号码
     * 必填: 是
     * 长度: 13
     * 说明: 银行预留手机号
     */
    @NotBlank(message = "手机号码不能为空")
    private String mobileno;

    /**
     * 卡有效期
     * 必填: 否
     * 长度: 4
     * 说明: 要快捷支付的卡有效期，卡号为借记卡时，无需输入，如需传入格式为（月年）
     */
    private String expireddate;

    /**
     * 卡校验码
     * 必填: 否
     * 长度: 3
     * 说明: 需要快捷支付的信用卡卡验证码
     */
    private String cvv2;

    /**
     * 优惠标识
     * 必填: 否
     * 长度: 32
     * 说明: 通过CAS044接口获取
     */
    private String coupontoken;
}
