package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayProductItemListRequest;
import com.fshows.msfpay.request.item.MsfpayProfitItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS001-网银支付请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayOnlineBankPayRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     * 示例: CM3000057716
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 外部用户号
     * 必填: 否
     * 长度: 32
     */
    private String outuserid;

    /**
     * 银行代码
     * 必填: 是
     * 长度: 8
     * 说明: 根据不同的银行代码送往不同的银行网关
     */
    @NotBlank(message = "银行代码不能为空")
    private String bankcode;

    /**
     * 卡类型
     * 必填: 是
     * 长度: 2
     * 说明: 01 纯借记卡，02 贷记卡
     */
    @NotBlank(message = "卡类型不能为空")
    private String cardtype;

    /**
     * 账户类型
     * 必填: 是
     * 长度: 2
     * 说明: 00对私
     */
    @NotBlank(message = "账户类型不能为空")
    private String accounttype;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 16,2
     * 说明: 以元单位，银行卡被扣费的金额,保留小数2位。整数位最大为14位。
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 订单类型
     * 必填: 是
     * 长度: 2
     * 说明: 订单类型：0:普通交易1:担保交易
     */
    @NotBlank(message = "订单类型不能为空")
    private String ordertype;

    /**
     * 平台手续费
     * 必填: 是
     * 长度: 16,2
     * 说明: 平台商户开通之后三方平台会告知订单收费规则按照三方指定的收费规则计算上送。当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotNull(message = "平台手续费不能为空")
    private BigDecimal patfee;

    /**
     * 分账类型
     * 必填: 是
     * 长度: 2
     * 说明: 见附录，当平台商户配置关闭分账功能后非必输,此时输入无效
     */
    @NotBlank(message = "分账类型不能为空")
    private String profittype;

    /**
     * 页面回调地址
     * 必填: 是
     * 长度: 128
     * 说明: 用于用户在银行网关输入信息完成之后做为页面回调的地址
     */
    @NotBlank(message = "页面回调地址不能为空")
    private String weburl;

    /**
     * 服务器回调地址
     * 必填: 是
     * 长度: 128
     * 说明: 订单成功之后作为服务器回调的地址
     */
    @NotBlank(message = "服务器回调地址不能为空")
    private String serverurl;

    /**
     * 分账信息
     * 必填: 是
     * 长度: 3000
     * JSON格式的分账信息
     * 对应对象: MsfpayProfitItemRequest
     */
    @NotNull(message = "分账信息不能为空")
    private MsfpayProfitItemListRequest profitlist;

    /**
     * 商品信息
     * 必填: 是
     * 长度: 255
     * JSON格式的商品信息
     * 对应对象: MsfpayProductItemListRequest
     */
    @NotNull(message = "商品信息不能为空")
    private MsfpayProductItemListRequest productlist;

    /**
     * 扩展字段
     * 必填: 否
     * 长度: 600
     */
    private String extendfield;

    /**
     * 项目编号
     * 必填: 否
     * 长度: 128
     */
    private String prno;
}
