package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * CMS013-二级商户进件请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMerchantRegisterRequest extends MsfpayBizRequest {

    /**
     * 客户类型
     * 必填: 是
     * 长度: 1
     * 说明: 1：个体工商户 2：企业商户 3：小微商户
     */
    @NotBlank(message = "客户类型不能为空")
    private String customertype;

    /**
     * 商户名称
     * 必填: 是
     * 长度: 256
     * 说明: 企业、小微商户结算卡只能绑定该名称下的银行卡，请谨慎填写。客户类型为小微商户时,请填写自然人姓名
     */
    @NotBlank(message = "商户名称不能为空")
    private String corname;

    /**
     * 商户简称
     * 必填: 是
     * 长度: 20
     */
    @NotBlank(message = "商户简称不能为空")
    private String shortname;

    /**
     * 经营地址
     * 必填: 是
     * 长度: 120
     * 说明: 长度10-120的JSON字符串
     */
    @NotBlank(message = "经营地址不能为空")
    private String managementaddress;

    /**
     * 联系人手机号
     * 必填: 否
     * 长度: 12
     * 说明: 商户类型为"单位"时，非必输；商户类型为"个体工商户"、"小微"时，必输
     */
    private String phone;

    /**
     * 联系人邮箱
     * 必填: 否
     * 长度: 120
     */
    private String email;

    /**
     * 清算目标
     * 必填: 否
     * 长度: 2
     * 说明: 默认00（支付账户）
     */
    private String settletarget;

    /**
     * 清算周期
     * 必填: 否
     * 长度: 2
     * 说明: 00 T+1、01 D+1
     */
    private String settleperiod;

    /**
     * 商户归属项目
     * 必填: 否
     * 长度: 2
     * 说明: 00自有商户，01民生拓展商户，02其他
     */
    private String merBelong;

    /**
     * 商户拓展经理
     * 必填: 否
     * 长度: 128
     */
    private String custManager;

    /**
     * 商户归属机构
     * 必填: 否
     * 长度: 128
     * 说明: merBelong为01时必填，格式如下：中国民生银行（XX分行）
     */
    private String custManagerOrg;

    /**
     * 客户经理所属子机构
     * 必填: 否
     * 长度: 128
     * 说明: 民生银行信用卡中心分中心名称
     */
    private String creditCenter;

    /**
     * 客户经理推荐码/工号
     * 必填: 否
     * 长度: 32
     * 说明: 民生银行信用卡中心员工工号后六位数字
     */
    private String creditCenterStaff;

    /**
     * 服务器通知地址
     * 必填: 否
     * 长度: 128
     * 说明: 商户平台认证审核后通知地址
     */
    private String serverurl;

    /**
     * 是否线下签约
     * 必填: 否
     * 长度: 2
     * 说明: 00 否 01 是，该字段只对企业商户生效
     */
    private String signOffLine;

    /**
     * 商户信息
     * 必填: 是
     * 长度: 256
     * 说明: 根据客户类型选择上传不同类型的商户信息，JSON格式
     * 企业商户：MsfpayEnterpriseMerchantRequest
     * 个体工商户：MsfpayIndividualBusinessRequest
     * 小微商户: MsfpayMicroMerchantRequest
     */
    @NotNull(message = "商户信息不能为空")
    private String merinfos;
}
