package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS044-商户开户意愿确认查询请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMerchantConfirmRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 二级商户号
     * 必填: 是
     * 长度: 12
     * 示例: CM3000057716
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 通道编号
     * Qr003、Qr004，由CMS011接口返回
     * 必填: 是
     * 长度: 32
     * 示例: Qr004
     */
    @NotBlank(message = "通道编号不能为空")
    private String chlcode;

    /**
     * 支付方式
     * ALI-支付宝  WEIXIN-微信
     * 仅支持微信、支付宝
     * 必填: 是
     * 长度: 32
     */
    @NotBlank(message = "支付方式不能为空")
    private String chltype;

    /**
     * 渠道子商户号
     * 微信子商户号或支付宝子商户号，由CMS011接口返回
     * 必填: 是
     * 长度: 32
     * 示例: 521882476
     */
    @NotBlank(message = "渠道子商户号不能为空")
    private String chlmerid;
}
